/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editpolicies;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;

import org.maskat.core.layout.TreeNode;
import org.maskat.ui.editors.layout.commands.DelBasicDefCommand;

public class TreeNodeComponentEditPolicy extends MaskatComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		TreeNode model = (TreeNode) getHost().getModel();
		return new DelBasicDefCommand(model.getParent(), model);
	}

	protected boolean canFeedbackToRequest(Request request) {
		return true;
	}
}
