/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Frame;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class FramePropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";

	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_HEIGHT = "_prop_height_";
	
	public static final String PROP_TITLE = "_prop_title_";
	
	public static final String PROP_AUTORESIZABLEH = "_prop_autoResizableH_";
	
	public static final String PROP_AUTORESIZABLEW = "_prop_autoResizableW_";
	
	public static final String PROP_AUTORESIZECONTENU = "_prop_autoResizeContenu_";
	
	public static final String PROP_AUTORESIZEPARENT = "_prop_autoResizeParent_";
	
	public static final String PROP_BOOLMAXI = "_prop_boolMaxi_";
	
	public static final String PROP_BOOLPRINT = "_prop_boolPrint_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_DYNAMIC = "_prop_dynamic_";
	
	public static final String PROP_OPEN = "_prop_open_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_PRINTTITLE = "_prop_printTitle_";

	public FramePropertySource(Frame frame) {
		super(frame);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_HEIGHT, "height"),
				  new MaskatTextPropertyDescriptor(PROP_TITLE, "title"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZABLEH, "autoResizableH"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZABLEW, "autoResizableW"),
//				  new MaskatTextPropertyDescriptor(PROP_AUTORESIZECONTENU, "autoResizeContenu"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZEPARENT, "autoResizeParent"),
				  new BooleanComboBoxPropertyDescriptor(PROP_BOOLMAXI, "boolMaxi"),
				  new BooleanComboBoxPropertyDescriptor(PROP_BOOLPRINT, "boolPrint"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DYNAMIC, "dynamic"),
				  new BooleanComboBoxPropertyDescriptor(PROP_OPEN, "open"),
				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  new MaskatTextPropertyDescriptor(PROP_PRINTTITLE, "printTitle")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_HEIGHT, "height");
	    propMap.put(PROP_TITLE, "title");
//	    propMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
//	    propMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
//	    propMap.put(PROP_AUTORESIZECONTENU, "autoResizeContenu");
	    propMap.put(PROP_AUTORESIZEPARENT, "autoResizeParent");
	    propMap.put(PROP_BOOLMAXI, "boolMaxi");
	    propMap.put(PROP_BOOLPRINT, "boolPrint");
	    propMap.put(PROP_DRAGGABLE, "draggable");
	    propMap.put(PROP_DYNAMIC, "dynamic");
	    propMap.put(PROP_OPEN, "open");
	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_PRINTTITLE, "printTitle");

	}
}
