/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.GridCellCombo;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class GridCellComboPropertySource implements IPropertySource {

	public static final String PROP_VALUE = "_prop_value_";

	public static final String PROP_TEXT = "_prop_text_";

	private static final IPropertyDescriptor[] descriptor = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_VALUE, "value"),
			new MaskatTextPropertyDescriptor(PROP_TEXT, "text") };
	
	private GridCellCombo gridCellCombo;

	public GridCellComboPropertySource(GridCellCombo gridCellCombo) {
		this.gridCellCombo = gridCellCombo;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptor;
	}

	public Object getPropertyValue(Object id) {
		if (PROP_VALUE.equals(id)) {
			return gridCellCombo.getValue();
		}
		if (PROP_TEXT.equals(id)) {
			return gridCellCombo.getText();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if (PROP_VALUE.equals(id)) {
			gridCellCombo.setValue((String) value);
		}
		if (PROP_TEXT.equals(id)) {
			gridCellCombo.setText((String) value);
		}
	}

	public String toString() {
		return "";
	}
}
