<?xml version='1.0' encoding='UTF-8'?>

<!DOCTYPE xsl:stylesheet [
    <!ENTITY nbsp "&#160;">
]>

<xsl:stylesheet xmlns:xalan="http://xml.apache.org/xslt" version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" encoding="iso-8859-1" indent="no" />

	<xsl:template match="rialto">
		
		<xsl:text disable-output-escaping="yes">
			<![CDATA[
<?php
define('PATH','../rialtoPHP');

include PATH."/RialtoPHPConfig.php";
include PATH."/RialtoPHPWriter.php";
include PATH."/RialtoPHPTag.php";
include PATH."/RialtoPHPScreen.php";

include PATH."/tags/AlertTag.php";
include PATH."/tags/ButtonTag.php";
include PATH."/tags/FrameTag.php";
include PATH."/tags/ComboTag.php";
include PATH."/tags/FormTag.php";
include PATH."/tags/GridTag.php";
include PATH."/tags/ImportTag.php";
include PATH."/tags/LayoutTag.php";
include PATH."/tags/LabelTag.php";
include PATH."/tags/PopUpTag.php";
include PATH."/tags/TextTag.php";
include PATH."/tags/CheckBoxTag.php";
include PATH."/tags/WindowTag.php";
include PATH."/tags/SplitterTag.php";
include PATH."/tags/TreeviewTag.php";
include PATH."/tags/TreeNodeTag.php";
include PATH."/tags/CallBackTag.php";
include PATH."/tags/RadioTag.php";
include PATH."/tags/ImageTag.php";
include PATH."/tags/CodeLabelTag.php";
include PATH."/tags/TabFolderTag.php";
include PATH."/tags/TabItemTag.php";

$rialtoPHPWriter = RialtoPHPWriter::getInstance();
echo $rialtoPHPWriter->addImport();
?>
<script type='text/javascript'>
function init(){     
<?php]]>
		</xsl:text>
		<xsl:choose>
  			<xsl:when test="@topParent">
    			<xsl:if test="@topParent=''">
					<xsl:apply-templates>
        				<xsl:with-param name="parent">document.body</xsl:with-param>
        			</xsl:apply-templates> 
        		</xsl:if> 
		        <xsl:if test="@topParent!=''">
					<xsl:apply-templates>
		        		<xsl:with-param name="parent"><xsl:value-of select='@topParent'/></xsl:with-param>
		        	</xsl:apply-templates> 
		        </xsl:if>
   			</xsl:when>
   			<xsl:otherwise>
				<xsl:apply-templates>
	        		<xsl:with-param name="parent">document.body</xsl:with-param>
	        	</xsl:apply-templates> 
   			</xsl:otherwise>
		</xsl:choose>
		
        
		<xsl:text disable-output-escaping="yes">
			<![CDATA[

echo $out; 
?>
}
</script>
</head>
<body onLoad='init()'/></body>
</html>]]>
		</xsl:text>
	</xsl:template>
	
	<xsl:template match="simpleWindow">
		<xsl:param name="parent"/>
    	$out.= $rialtoPHPWriter->windowTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@title'/>', '<xsl:value-of select='$parent'/>');
    	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>	


	<xsl:template match="popup">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->showPopUp('<xsl:value-of select='@name'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@height'/>', '<xsl:value-of select='@width'/>', '<xsl:value-of select='@title'/>', '<xsl:value-of select='$parent'/>');
		<xsl:apply-templates/>
	</xsl:template>	
		
	<xsl:template match="alert">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->showAlert('<xsl:value-of select='@name'/>', '');
		<xsl:apply-templates/>
	</xsl:template>	
	  	
	<xsl:template match="image">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->imageTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@in_path'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@onclick'/>', '<xsl:value-of select='$parent'/>');
	</xsl:template>
		
	<xsl:template match="splitter">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->splitterTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@height'/>', '<xsl:value-of select='@width'/>', '<xsl:value-of select='@prop'/>', '<xsl:value-of select='$parent'/>');
		<xsl:for-each select="divSplitter">
			<xsl:apply-templates>
				
        		<xsl:with-param name="parent" ><xsl:value-of select='../@name'/>.div<xsl:value-of select='position()'/></xsl:with-param>
       		</xsl:apply-templates> 
		</xsl:for-each>
	</xsl:template>	
		
	<xsl:template match="treeview">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->treeviewTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@width'/>', '<xsl:value-of select='$parent'/>');
	   	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
        	<xsl:with-param name="treeName" ><xsl:value-of select='@name'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>
		
	<xsl:template match="treenode">
		<xsl:param name="parent"/>
		<xsl:param name="treeName"/>
		$out.= $rialtoPHPWriter->treeNodeTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@text'/>', '<xsl:value-of select='@url'/>', '<xsl:value-of select='@onclick'/>', '<xsl:value-of select='$treeName'/>', '<xsl:value-of select='$parent'/>', '<xsl:value-of select='@iconOn'/>', '<xsl:value-of select='@iconOff'/>');
	   	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
           	<xsl:with-param name="treeName" ><xsl:value-of select='$treeName'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>
		
	<xsl:template match="frame">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->frameTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@width'/>', '<xsl:value-of select='@height'/>', '<xsl:value-of select='@title'/>', '<xsl:value-of select='@open'/>', '<xsl:value-of select='@dynamic'/>', '<xsl:value-of select='@position'/>', '<xsl:value-of select='@draggable'/>', '<xsl:value-of select='$parent'/>');
	   	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>	

	<xsl:template match="form">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->formTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@url'/>', '<xsl:value-of select='$parent'/>');
   	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>

	<xsl:template match="text">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->textTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@width'/>', '<xsl:value-of select='@datatype'/>', '<xsl:value-of select='$parent'/>', '<xsl:value-of select='@isRequired'/>', '<xsl:value-of select='@disable'/>', '<xsl:value-of select='@initValue'/>');
	</xsl:template>	
		
	<xsl:template match="label">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->labelTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@text'/>', '<xsl:value-of select='$parent'/>', '<xsl:value-of select='@className'/>');
	</xsl:template>
		
	<xsl:template match="combo">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->comboTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@width'/>', $array, '<xsl:value-of select='$parent'/>');
	</xsl:template>
		
	<xsl:template match="checkbox">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->checkBoxTag('<xsl:value-of select='@name'/>', '<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='$parent'/>', '<xsl:value-of select='@label'/>', '<xsl:value-of select='@checked'/>');
	</xsl:template>

	<xsl:template match="radio">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->radioTag('<xsl:value-of select='@name'/>','<xsl:value-of select='@top'/>', '<xsl:value-of select='@left'/>', '<xsl:value-of select='@width'/>', '<xsl:value-of select='@group'/>', '<xsl:value-of select='@text'/>', '<xsl:value-of select='$parent'/>');
	</xsl:template>
		
	<xsl:template match="codeLabel">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->codeLabelTag('<xsl:value-of select='@name'/>','<xsl:value-of select='@top'/>','<xsl:value-of select='@left'/>','<xsl:value-of select='@width'/>','<xsl:value-of select='@url'/>','<xsl:value-of select='$parent'/>');
	</xsl:template>
		 
	<xsl:template match="button">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->buttonTag('<xsl:value-of select='@name'/>','<xsl:value-of select='@title'/>','<xsl:value-of select='@top'/>','<xsl:value-of select='@left'/>','<xsl:value-of select='@alt'/>','','<xsl:value-of select='$parent'/>');
	</xsl:template>
		
	<xsl:template match="grid">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->gridTag('<xsl:value-of select='@name'/>','<xsl:value-of select='@top'/>','<xsl:value-of select='@left'/>','<xsl:value-of select='@height'/>',array(),'<xsl:value-of select='$parent'/>');
		<xsl:apply-templates/>
	</xsl:template>
		
	<xsl:template match="gridHeader">
		<xsl:param name="parent"/>
	</xsl:template>	
		
	<xsl:template match="gridLine">
		<xsl:param name="parent"/>
	</xsl:template>	
		
	<xsl:template match="gridCell">
		<xsl:param name="parent"/>
	</xsl:template>	
		
	<xsl:template match="tabfolder">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->tabFolderTag('<xsl:value-of select='@name'/>','<xsl:value-of select='@top'/>','<xsl:value-of select='@left'/>','<xsl:value-of select='@width'/>','<xsl:value-of select='@height'/>','<xsl:value-of select='$parent'/>');
	   	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>
		
	<xsl:template match="tabitem">
		<xsl:param name="parent"/>
		$out.= $rialtoPHPWriter->tabItemTag('<xsl:value-of select='@name'/>','<xsl:value-of select='@title'/>','<xsl:value-of select='$parent'/>');
	   	<xsl:apply-templates>
        	<xsl:with-param name="parent" ><xsl:value-of select='@name'/></xsl:with-param>
        </xsl:apply-templates> 
	</xsl:template>			
</xsl:stylesheet>