/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.xml.ClassDescriptorEnumeration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;

public class ClassDescriptorResolverImpl
implements ClassDescriptorResolver {
    private static final String PKG_MAPPING_FILE = ".castor.xml";
    private static final String PKG_CDR_LIST_FILE = ".castor.cdr";
    private static final String DESCRIPTOR_PREFIX = "Descriptor";
    private static final String INTERNAL_CONTAINER_NAME = "-error-if-this-is-used-";
    private static final Mapping NULL_MAPPING = new Mapping();
    private static final Properties NULL_CDR_FILE = new Properties();
    private Hashtable _cacheViaClass = new Hashtable();
    private Hashtable _cacheViaName = new Hashtable();
    private Hashtable _classNotFoundList = null;
    private Hashtable _packageMappings = new Hashtable();
    private Hashtable _packageCDList = new Hashtable();
    private Introspector _introspector = null;
    private ClassLoader _loader = null;
    private boolean _loadPackageMappings = true;
    private XMLMappingLoader _mappingLoader = null;
    private boolean _useIntrospection = true;

    public ClassDescriptorResolverImpl() {
    }

    public ClassDescriptorResolverImpl(ClassLoader loader) {
        this();
        this._loader = loader;
    }

    public void associate(Class type, XMLClassDescriptor classDesc) {
        if (type == null) {
            throw new IllegalArgumentException("argument 'type' must not be null.");
        }
        if (classDesc == null) {
            if (type != null) {
                this._cacheViaClass.remove(type);
            }
        } else {
            this._cacheViaClass.put(type, classDesc);
            String xmlName = classDesc.getXMLName();
            if (xmlName != null && xmlName.length() > 0 && !INTERNAL_CONTAINER_NAME.equals(xmlName)) {
                String nameKey = xmlName;
                String ns = classDesc.getNameSpaceURI();
                if (ns != null && ns.length() > 0) {
                    nameKey = ns + ':' + xmlName;
                }
                this._cacheViaName.put(nameKey, classDesc);
            }
        }
    }

    public Introspector getIntrospector() {
        if (this._introspector == null) {
            this._introspector = new Introspector();
        }
        return this._introspector;
    }

    public XMLMappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    public XMLClassDescriptor resolve(Class type) throws ResolverException {
        if (type == null) {
            return null;
        }
        XMLClassDescriptor classDesc = (XMLClassDescriptor)this._cacheViaClass.get(type);
        if (classDesc != null) {
            return classDesc;
        }
        if (this._mappingLoader != null && (classDesc = (XMLClassDescriptor)this._mappingLoader.getDescriptor(type)) != null) {
            this._cacheViaClass.put(type, classDesc);
            return classDesc;
        }
        String pkgName = this.getPackageName(type.getName());
        Mapping mapping = this.loadPackageMapping(pkgName, type.getClassLoader());
        if (mapping != null) {
            try {
                MappingLoader mapLoader = (MappingLoader)mapping.getResolver(Mapping.XML);
                classDesc = (XMLClassDescriptor)mapLoader.getDescriptor(type);
            }
            catch (MappingException mx) {
                // empty catch block
            }
            if (classDesc != null) {
                this.associate(type, classDesc);
                return classDesc;
            }
        }
        if (this.loadPackageList(pkgName, type.getClassLoader()) && (classDesc = (XMLClassDescriptor)this._cacheViaClass.get(type)) != null) {
            return classDesc;
        }
        String className = type.getName() + DESCRIPTOR_PREFIX;
        try {
            ClassLoader loader = type.getClassLoader();
            Class dClass = this.loadClass(className, loader);
            classDesc = (XMLClassDescriptor)dClass.newInstance();
            this._cacheViaClass.put(type, classDesc);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception ex) {
            String err = "instantiation error for class: " + className;
            err = err + "; " + ex.toString();
            throw new ResolverException(err, ex);
        }
        if (classDesc == null && this._useIntrospection) {
            try {
                classDesc = this.getIntrospector().generateClassDescriptor(type);
                if (classDesc != null) {
                    this._cacheViaClass.put(type, classDesc);
                }
            }
            catch (MarshalException mx) {
                throw new ResolverException(mx);
            }
        }
        return classDesc;
    }

    public XMLClassDescriptor resolve(String className) throws ResolverException {
        return this.resolve(className, null);
    }

    public XMLClassDescriptor resolve(String className, ClassLoader loader) throws ResolverException {
        XMLClassDescriptor classDesc = null;
        if (className == null || className.length() == 0) {
            String error = "Cannot resolve a null or zero-length class name.";
            throw new IllegalArgumentException(error);
        }
        if (this._mappingLoader != null && (classDesc = (XMLClassDescriptor)this._mappingLoader.getDescriptor(className)) != null) {
            return classDesc;
        }
        String pkgName = this.getPackageName(className);
        Mapping mapping = this.loadPackageMapping(pkgName, loader);
        if (mapping != null) {
            try {
                MappingLoader mapLoader = (MappingLoader)mapping.getResolver(Mapping.XML);
                classDesc = (XMLClassDescriptor)mapLoader.getDescriptor(className);
            }
            catch (MappingException mx) {
                // empty catch block
            }
            if (classDesc != null) {
                if (classDesc.getJavaClass() != null) {
                    this.associate(classDesc.getJavaClass(), classDesc);
                }
                return classDesc;
            }
        }
        Class _class = null;
        try {
            _class = this.loadClass(className, loader);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.saveClassNotFound(className, new ClassNotFoundException(ncdfe.getMessage()));
        }
        catch (ClassNotFoundException cnfe) {
            this.saveClassNotFound(className, cnfe);
        }
        if (_class != null) {
            classDesc = this.resolve(_class);
        }
        if (classDesc == null && _class == null) {
            String dClassName = className + DESCRIPTOR_PREFIX;
            try {
                Class dClass = this.loadClass(dClassName, loader);
                classDesc = (XMLClassDescriptor)dClass.newInstance();
                if (classDesc.getJavaClass() != null) {
                    this.associate(classDesc.getJavaClass(), classDesc);
                }
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassNotFoundException cnfe) {
                this.saveClassNotFound(className, cnfe);
            }
        }
        return classDesc;
    }

    private void saveClassNotFound(String className, ClassNotFoundException cnfe) {
        if (this._classNotFoundList == null) {
            this._classNotFoundList = new Hashtable();
        }
        this._classNotFoundList.put(className, cnfe);
    }

    public XMLClassDescriptor resolveByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String error = "Cannot resolve a null or zero-length xml name.";
            throw new IllegalArgumentException(error);
        }
        XMLClassDescriptor classDesc = null;
        Enumeration enumeration = null;
        String nameKey = xmlName;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            nameKey = namespaceURI + ':' + xmlName;
        }
        if ((classDesc = (XMLClassDescriptor)this._cacheViaName.get(nameKey)) != null) {
            return classDesc;
        }
        XMLClassDescriptor possibleMatch = null;
        if (this._mappingLoader != null) {
            enumeration = this._mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                classDesc = (XMLClassDescriptor)enumeration.nextElement();
                if (xmlName.equals(classDesc.getXMLName())) {
                    if (this.namespaceEquals(namespaceURI, classDesc.getNameSpaceURI())) {
                        this._cacheViaName.put(nameKey, classDesc);
                        return classDesc;
                    }
                    possibleMatch = classDesc;
                }
                classDesc = null;
            }
        }
        enumeration = this._cacheViaClass.elements();
        while (enumeration.hasMoreElements()) {
            classDesc = (XMLClassDescriptor)enumeration.nextElement();
            if (xmlName.equals(classDesc.getXMLName())) {
                if (this.namespaceEquals(namespaceURI, classDesc.getNameSpaceURI())) {
                    this._cacheViaName.put(nameKey, classDesc);
                    return classDesc;
                }
                if (possibleMatch == null) {
                    possibleMatch = classDesc;
                } else if (possibleMatch != classDesc) {
                    possibleMatch = null;
                }
            }
            classDesc = null;
        }
        Enumeration mappings = this._packageMappings.elements();
        while (mappings.hasMoreElements()) {
            Mapping mapping = (Mapping)mappings.nextElement();
            try {
                MappingResolver resolver = mapping.getResolver(Mapping.XML);
                enumeration = resolver.listDescriptors();
                while (enumeration.hasMoreElements()) {
                    classDesc = (XMLClassDescriptor)enumeration.nextElement();
                    if (!xmlName.equals(classDesc.getXMLName())) continue;
                    if (this.namespaceEquals(namespaceURI, classDesc.getNameSpaceURI())) {
                        this._cacheViaName.put(nameKey, classDesc);
                        return classDesc;
                    }
                    if (possibleMatch == null) {
                        possibleMatch = classDesc;
                        continue;
                    }
                    if (possibleMatch == classDesc) continue;
                    possibleMatch = null;
                }
            }
            catch (MappingException mx) {
                // empty catch block
            }
            classDesc = null;
        }
        if (classDesc == null) {
            classDesc = possibleMatch;
        }
        return classDesc;
    }

    public ClassDescriptorEnumeration resolveAllByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String error = "Cannot resolve a null or zero-length xml name.";
            throw new IllegalArgumentException(error);
        }
        XCDEnumerator xcdEnumerator = new XCDEnumerator();
        XMLClassDescriptor classDesc = null;
        Enumeration enumeration = null;
        if (this._mappingLoader != null) {
            enumeration = this._mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                classDesc = (XMLClassDescriptor)enumeration.nextElement();
                if (!xmlName.equals(classDesc.getXMLName())) continue;
                xcdEnumerator.add(classDesc);
            }
        }
        enumeration = this._cacheViaClass.elements();
        while (enumeration.hasMoreElements()) {
            classDesc = (XMLClassDescriptor)enumeration.nextElement();
            if (!xmlName.equals(classDesc.getXMLName())) continue;
            xcdEnumerator.add(classDesc);
        }
        Enumeration mappings = this._packageMappings.elements();
        while (mappings.hasMoreElements()) {
            Mapping mapping = (Mapping)mappings.nextElement();
            try {
                MappingResolver resolver = mapping.getResolver(Mapping.XML);
                enumeration = resolver.listDescriptors();
                while (enumeration.hasMoreElements()) {
                    classDesc = (XMLClassDescriptor)enumeration.nextElement();
                    if (!xmlName.equals(classDesc.getXMLName())) continue;
                    xcdEnumerator.add(classDesc);
                }
            }
            catch (MappingException mx) {
            }
        }
        return xcdEnumerator;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setIntrospection(boolean enable) {
        this._useIntrospection = enable;
    }

    public void setLoadPackageMappings(boolean loadPackageMappings) {
        this._loadPackageMappings = loadPackageMappings;
    }

    public void setMappingLoader(XMLMappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
    }

    private Class loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        Object exception;
        if (this._classNotFoundList != null && (exception = this._classNotFoundList.get(className)) != null) {
            throw (ClassNotFoundException)exception;
        }
        try {
            if (loader != null) {
                return loader.loadClass(className);
            }
            if (this._loader != null) {
                return this._loader.loadClass(className);
            }
            return Class.forName(className);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ClassNotFoundException(ncdfe.getMessage());
        }
    }

    private boolean namespaceEquals(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null || ns2.length() == 0;
        }
        if (ns2 == null) {
            return ns1.length() == 0;
        }
        return ns1.equals(ns2);
    }

    private synchronized boolean loadPackageList(String packageName, ClassLoader loader) throws ResolverException {
        URL url;
        String filename;
        Properties list;
        if (packageName == null) {
            packageName = "";
        }
        if ((list = (Properties)this._packageCDList.get(packageName)) != null) {
            return false;
        }
        if (packageName.length() == 0) {
            filename = PKG_CDR_LIST_FILE;
        } else {
            filename = packageName.replace('.', '/');
            filename = filename + "/" + PKG_CDR_LIST_FILE;
        }
        if (loader == null) {
            loader = this._loader;
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((url = loader.getResource(filename)) != null) {
            try {
                list = new Properties();
                list.load(url.openStream());
                this._packageCDList.put(packageName, list);
                Enumeration<Object> classes = list.keys();
                XMLClassDescriptor xcd = null;
                while (classes.hasMoreElements()) {
                    String className1 = (String)classes.nextElement();
                    String className2 = list.getProperty(className1);
                    try {
                        Class type = this.loadClass(className1, loader);
                        Class desc = this.loadClass(className2, loader);
                        xcd = (XMLClassDescriptor)desc.newInstance();
                        this.associate(type, xcd);
                    }
                    catch (ClassNotFoundException cnfx) {
                    }
                    catch (InstantiationException ix) {
                    }
                    catch (IllegalAccessException iax) {}
                }
                return true;
            }
            catch (IOException iox) {
                throw new ResolverException(iox);
            }
        }
        this._packageCDList.put(packageName, NULL_CDR_FILE);
        return false;
    }

    private synchronized Mapping loadPackageMapping(String packageName, ClassLoader loader) throws ResolverException {
        URL url;
        String filename;
        Mapping mapping;
        if (!this._loadPackageMappings) {
            return null;
        }
        if (packageName == null) {
            packageName = "";
        }
        if ((mapping = (Mapping)this._packageMappings.get(packageName)) != null) {
            if (mapping == NULL_MAPPING) {
                return null;
            }
            return mapping;
        }
        if (packageName.length() == 0) {
            filename = PKG_MAPPING_FILE;
        } else {
            filename = packageName.replace('.', '/');
            filename = filename + "/" + PKG_MAPPING_FILE;
        }
        if (loader == null) {
            loader = this._loader;
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((url = loader.getResource(filename)) != null) {
            try {
                mapping = new Mapping(loader);
                mapping.loadMapping(url);
                this._packageMappings.put(packageName, mapping);
            }
            catch (IOException iox) {
                throw new ResolverException(iox);
            }
            catch (MappingException mx) {
                throw new ResolverException(mx);
            }
        } else {
            this._packageMappings.put(packageName, NULL_MAPPING);
        }
        return mapping;
    }

    private String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            return className.substring(0, idx);
        }
        return null;
    }

    class XCDEnumerator
    implements ClassDescriptorEnumeration {
        private Entry _current = null;
        private Entry _last = null;

        XCDEnumerator() {
        }

        protected void add(XMLClassDescriptor classDesc) {
            Entry entry = new Entry();
            entry.classDesc = classDesc;
            if (this._current == null) {
                this._current = entry;
                this._last = entry;
            } else {
                this._last.next = entry;
                this._last = entry;
            }
        }

        public boolean hasNext() {
            return this._current != null;
        }

        public XMLClassDescriptor getNext() {
            if (this._current == null) {
                return null;
            }
            Entry entry = this._current;
            this._current = this._current.next;
            return entry.classDesc;
        }

        class Entry {
            XMLClassDescriptor classDesc = null;
            Entry next = null;

            Entry() {
            }
        }
    }
}

