<?xml version="1.0" encoding="Shift_JIS"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

   <xsl:output method="xml" encoding="Shift_JIS"/>

   <xsl:template match="bind|source">
      <xsl:variable name="child" select="@node"/>
      <xsl:variable name="minOccurs" select="@minOccurs"/>
      <xsl:variable name="maxOccurs" select="@maxOccurs"/>
      <xsl:element name="{$child}">
         <xsl:if test="string-length($minOccurs) != 0">
            <xsl:attribute name="xsi:minOccurs">
               <xsl:value-of select="@minOccurs"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="string-length($maxOccurs) != 0">
            <xsl:attribute name="xsi:maxOccurs">
               <xsl:value-of select="@maxOccurs"/>
            </xsl:attribute>
         </xsl:if>
         <xsl:value-of select="@type"/>
      </xsl:element>
   </xsl:template>

   <xsl:template match="param">
         <xsl:variable name="rootNode" select="@rootNode"/>
         <xsl:if test="string-length($rootNode) != 0">
            <xsl:element name="{$rootNode}">
               <xsl:for-each select="source">
                  <xsl:variable name="childNode" select="@childNode"/>
                  <xsl:variable name="idxRef" select="@idxRef"/>
                  <xsl:variable name="nodeName" select="@node"/>
                  <xsl:variable name="minOccurs" select="@minOccurs"/>
                  <xsl:variable name="maxOccurs" select="@maxOccurs"/>

                  <xsl:choose>
                     <!-- idxRef L -->
                     <xsl:when test="string-length($idxRef) != 0">
                        <xsl:element name="{$nodeName}">
                           <xsl:apply-templates select="bind"/>
                        </xsl:element>
                     </xsl:when>
                     
                     <!-- childNode L -->
                     <xsl:when test="string-length($childNode) != 0">
                        <xsl:element name="{$nodeName}">
                           <xsl:element name="{$childNode}">
                              <xsl:apply-templates select="bind"/>
                           </xsl:element>
                        </xsl:element>
                     </xsl:when>
                     
                     <!-- childNode ̒ʏm[h -->
                     <xsl:otherwise>
                        <xsl:apply-templates select="."/>
                     </xsl:otherwise>
                  </xsl:choose>
                  
               </xsl:for-each>
            </xsl:element>
         </xsl:if>
   </xsl:template>

   <xsl:template match="result">
         <xsl:variable name="rootNode" select="@rootNode"/>
         <xsl:if test="string-length($rootNode) != 0">
            <xsl:element name="{$rootNode}">
               <xsl:for-each select="target">
                  <xsl:variable name="in" select="@in"/>
                  <xsl:variable name="inkey" select="@inkey"/>
                  <xsl:variable name="type" select="@type"/>
                  <xsl:if test="string($type) != 'local'">
                     <xsl:choose>
                        <!-- in L -->
                        <xsl:when test="string-length($in) != 0">
                           <xsl:element name="{$in}">
                              <!-- inkey L -->
                              <xsl:if test="string-length($inkey) != 0">
                                 <xsl:element name="{$inkey}">
                                    <xsl:for-each select="bind">
                                       <xsl:apply-templates select="."/>
                                    </xsl:for-each>
                                 </xsl:element>
                              </xsl:if>
                              <!-- inkey Ȃ -->
                              <xsl:if test="string-length($inkey) = 0">
                                 <!-- minOccurs,maxOccurs,type..... -->
                                 <xsl:value-of select="@type"/>
                              </xsl:if>
                           </xsl:element>
                        </xsl:when>
                     </xsl:choose>
                  </xsl:if>
               </xsl:for-each>
            </xsl:element>
         </xsl:if>
   </xsl:template>

   <xsl:template match="/">
      <xsl:for-each select="eventDef/component/event">
         <xsl:variable name="type" select="@type"/>
         <xsl:variable name="ref" select="@ref"/>
         <xsl:if test="string($type) != 'local'">
            <xsl:element name="sendTele">
               <xsl:attribute name="component">
                  <xsl:value-of select="../@id"/>
               </xsl:attribute>
               <xsl:attribute name="event">
                  <xsl:value-of select="@id"/>
               </xsl:attribute>
               <xsl:if test="string-length($ref) = 0">
                  <xsl:apply-templates select="param"/>
               </xsl:if>
               <xsl:if test="string-length($ref) != 0">
                  <xsl:apply-templates
                     select="/eventDef/eventRef[@id=$ref]/param"/>
               </xsl:if>
            </xsl:element>
            <xsl:element name="recvTele">
               <xsl:attribute name="component">
                  <xsl:value-of select="../@id"/>
               </xsl:attribute>
               <xsl:attribute name="event">
                  <xsl:value-of select="@id"/>
               </xsl:attribute>
               <xsl:if test="string-length($ref) = 0">
                  <xsl:apply-templates select="result"/>
               </xsl:if>
               <xsl:if test="string-length($ref) != 0">
                  <xsl:apply-templates
                     select="/eventDef/eventRef[@id=$ref]/result"/>
               </xsl:if>
            </xsl:element>
         </xsl:if>
      </xsl:for-each>
      
   </xsl:template>
   
</xsl:stylesheet>