/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

public class PropertyPluginConfig {
	public static final String METRIC_XY = "METRIC_XY",
			METRIC_XYHEIGHT = "METRIC_XYHEIGHT", METRIC_XYWIDTH = "METRIC_XYWIDTH",
			METRIC_ALL = "METRIC_ALL";

	PropertyPluginConfig(String name, String type) {
		this.name = name;
		this.type = type;
	}

	private String name;

	private String type;

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public boolean isMetricProp() {
		return (METRIC_XY.equals(type) || METRIC_ALL.equals(type)
				|| METRIC_XYHEIGHT.equals(type) || METRIC_XYWIDTH.equals(type));
	}

	public boolean isEventProp() {
		return "event".equals(type);
	}
}
