/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.maskat.framework.IBasicDefVisitor;
import org.maskat.framework.eventdef.IEventDefSource;

public class LayoutDef extends ContainerDef {

	private String objs = "";

	private String refParentHTML;

	private IEventDefSource layoutEvtDefSrc;

	private MaskatDef maskatDef;

	public IEventDefSource getLayoutEvtDefSrc() {
		return layoutEvtDefSrc;
	}

	public void setLayoutEvtDefSrc(IEventDefSource layoutEvtDefSrc) {
		this.layoutEvtDefSrc = layoutEvtDefSrc;
	}

	public IContainerDef getLayoutDef() {
		return this;
	}

	public String getRefParentHTML() {
		return refParentHTML;
	}

	public void setRefParentHTML(String refParentHTML) {
		this.refParentHTML = refParentHTML;
	}

	public MaskatDef getMaskatDef() {
		return maskatDef;
	}

	public void setMaskatDef(MaskatDef maskatDef) {
		this.maskatDef = maskatDef;
	}

	public String getObjs() {
		return objs;
	}

	public void addObjs(String objs) {
		this.objs += objs + ",";// ua,b,c,d,v + ue,fv + u,v
	}

	/**
	 * Read the radio group data, set the group properties of the corresponding
	 * radio.
	 */
	public void unpackRadioGroup() {
		Iterator it = this.getTypedChildren(RadioGroupDef.class);
		if (it == null)
			return;

		final Map nameToGroupMap = new HashMap();
		while (it.hasNext()) {
			RadioGroupDef rg = (RadioGroupDef) it.next();
			String groupName = rg.getName();

			Iterator memberIt = rg.getTypedChildren(RadioMemberDef.class);
			while (memberIt != null && memberIt.hasNext()) {
				// Get the groupMember defs
				RadioMemberDef member = (RadioMemberDef) memberIt.next();
				if (member.getRef() != null)
					nameToGroupMap.put(member.getRef(), groupName);
			}
		}
		// Find all the radiodef in this layout, then set groupName
		// to the group property.
		if (nameToGroupMap.size() > 0) {
			this.accept(new IBasicDefVisitor() {
				public void visit(Object def) {
					if (def instanceof RadioDef) {
						RadioDef radioDef = (RadioDef) def;
						radioDef
								.setGroup((String) nameToGroupMap.get(radioDef.getName()));
					}
				}
			});
		}
		// The information contained by radio group has all been transfered to
		// the radio component, so the radio group is of no use. delete.
		this.removeAllByType(RadioGroupDef.class);
	}

	/**
	 * Create the radio group node according to the group properties of all the
	 * radio.
	 * 
	 */
	public void packRadioGroup() {
		// Delete all the radio group node before pack.
		this.removeAllByType(RadioGroupDef.class);

		final Map radioGroupMap = new HashMap();
		this.accept(new IBasicDefVisitor() {

			public void visit(Object def) {
				if (def instanceof RadioDef) {
					// Create or modify a radioGroup according to the group of
					// the radio
					RadioDef radioDef = (RadioDef) def;
					String group = radioDef.getGroup();
					if (group == null || "".equals(group))
						return;
					RadioGroupDef radioGroup = (RadioGroupDef) radioGroupMap.get(group);
					if (radioGroup == null) {
						radioGroup = new RadioGroupDef();
						radioGroup.setName(group);
						radioGroupMap.put(group, radioGroup);
					}
					radioGroup.addMember(radioDef.getName());
				}
			}
		});
		// Add all the radioGroup to the layout
		if (radioGroupMap.values() != null) {
			for (Iterator it = radioGroupMap.values().iterator(); it.hasNext();) {
				this.addChildToIdx(it.next(), 0);// radioGroupm[h͈Ԑ擪
			}
		}
	}
}