/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property.descriptor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * eLXgvpeBfBXNv^Anull̒l͋e悤ɂȂ
 * 
 * @author shengshen
 * 
 */
public class MaskatTextPropertyDescriptor extends TextPropertyDescriptor {

	public MaskatTextPropertyDescriptor(Object id, String displayName) {
		super(id, displayName);
	}

	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new MaskatTextCellEditor(parent);
		if (getValidator() != null)
			editor.setValidator(getValidator());
		return editor;
	}

	private static class MaskatTextCellEditor extends TextCellEditor {
		public MaskatTextCellEditor(Composite parent) {
			super(parent);
		}

		protected void doSetValue(Object value) {
			if (value == null) {
				// nullł΁A󔒕GfB^[ɕ\
				value = "";
			}
			super.doSetValue(value);
		}

		protected Object doGetValue() {
			Object value = super.doGetValue();
			if ("".equals(value)) {
				// GfB^[̒l͋󔒂̕ł΁AnullƂĈ
				return null;
			}
			return value;
		}
	}
}
