/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

/**
 * The id object for the <code>IPropertyDescriptor</code>s of the customized
 * component.<br>
 * Note: All of the <code>IPropertyDescriptor</code>s of
 * customized component have key of type CustCompPropDescKey. 
 * 
 * @see PluginDefFactory#dealPropertyConfig(PropertyPluginConfig, String,
 *      String)
 * 
 * @author shengshen
 */
public class CustCompPropDescKey {
	CustCompPropDescKey(String compNodeName, String propName) {
		this.compNodeName = compNodeName;
		this.propName = propName;
	}

	private String compNodeName;

	private String propName;

	public String getCompNodeName() {
		return compNodeName;
	}

	public String getPropName() {
		return propName;
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof CustCompPropDescKey))
			return false;
		if (obj == null)
			return false;
		CustCompPropDescKey key = (CustCompPropDescKey) obj;
		if (compNodeName == null) {
			if (key.getCompNodeName() != null)
				return false;
		} else {
			if (!compNodeName.equals(key.getCompNodeName()))
				return false;
		}
		if (propName == null) {
			if (key.getPropName() != null)
				return false;
		} else {
			if (!propName.equals(key.getPropName()))
				return false;
		}
		return true;
	}

	public int hashCode() {
		int hashCodeA = 0;
		int hashCodeB = 0;
		if (compNodeName != null)
			hashCodeA = compNodeName.hashCode();
		if (propName != null)
			hashCodeB = propName.hashCode();
		return hashCodeA + hashCodeB;
	}
}
