/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.ide.gef.figure.TabFigure;
import org.maskat.ide.gef.models.TabDef;

/**
 * TabFolderR|[lg̃^u{^
 * 
 * @author shengshen
 * 
 */
public class TabEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {

	public static final int minimalTabDisplayWidth = 10;

	TabFigure tabFigure;

	public void activate() {
		super.activate();
		TabDef model = (TabDef) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		TabDef model = (TabDef) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected IFigure createFigure() {
		final TabDef tab = (TabDef) getModel();

		tabFigure = new TabFigure(tab.getName());
		tabFigure.setText(tab.getTitle());
		tabFigure.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		tabFigure.setForegroundColor(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));

		tabFigure.setCursor(new Cursor(null, SWT.CURSOR_HAND));

		tabFigure.addMouseListener(new MouseListener.Stub() {
			public void mousePressed(MouseEvent me) {
				TabFolderEditPart tabFolder = (TabFolderEditPart) TabEditPart.this
						.getParent();
				tabFolder.switchToPage(tab.getName());
			}
		});
		return tabFigure;
	}

	protected void createEditPolicies() {
	}

	protected void refreshVisuals() {
		TabDef tab = (TabDef) getModel();
		TabFolderDef tabFolderDef = (TabFolderDef) tab.getParent();
		selfLayout(tabFolderDef.getWidthTabName());
	}

	public void selfLayout(String widthTabName) {
		TabDef tab = (TabDef) getModel();
		TabFolderDef tabFolderDef = (TabFolderDef) tab.getParent();
		int idx = tabFolderDef.getTabIdxByName(tab.getName());
		// parentɒ`ԂɂāAʒuvZ
		int tabWidth = toTabDisplayWidth(widthTabName);
		Rectangle constraint = new Rectangle(idx * tabWidth, 0, tabWidth, 15);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);

	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("title".equals(evt.getPropertyName())) {
			TabFigure tabFig = (TabFigure) getFigure();
			tabFig.setText((String) evt.getNewValue());
		}
	}

	/**
	 * ^u^Cg\p̕ԂiminimalTabDisplayWidthȉł΁AminimalTabDisplayWidthԂj<br>
	 * ܂A^u^Cg̕\ŏ
	 * 
	 * @param widthTabName
	 * @return
	 */
	public static int toTabDisplayWidth(String widthTabName) {
		try {
			int width = Integer.parseInt(widthTabName);
			return Math.max(width, minimalTabDisplayWidth);
		} catch (NumberFormatException e) {
			return minimalTabDisplayWidth;
		}
	}
}