/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import java.util.Iterator;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.TreeSearch;

public class LayoutFigure extends Layer {

	MaskatFigureHelper helper;

	public LayoutFigure() {
		helper = new MaskatFigureHelper(this);
	}

	/**
	 * 
	 * @param name
	 * @param firstOnly
	 *            true:ɓfigureƑ삪~߂
	 * @return ɓfigure邩ǂtO
	 */
	public boolean switchNamedComponentVisibility(String name, boolean firstOnly) {
		return switchVisibility(this, name, firstOnly);
	}

	private boolean switchVisibility(IFigure figure, String name, boolean firstOnly) {
		if (name == null) {
			throw new IllegalArgumentException("parameter name is null.");
		}
		boolean found = false;
		if (figure.getChildren() != null) {
			for (Iterator it = figure.getChildren().iterator(); it != null
					&& it.hasNext();) {
				IFigure child = (IFigure) it.next();
				if (child instanceof INamedFigure) {
					if (name.equals(((INamedFigure) child).getName())) {
						child.setVisible(!child.isVisible());
						if (firstOnly)
							return true;
					}
				}
				found = switchVisibility(child, name, firstOnly);
				if (found && firstOnly)
					return true;
			}
		}
		return found;
	}

	/**
	 * comboItem̃}EXI𓮍Ή
	 */
	protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
		return helper.findDescendantAtExcluding(x, y, search);
	}

	/**
	 * comboItem̕\Ή߂
	 */
	protected void paintChildren(Graphics graphics) {
		super.paintChildren(graphics);

		helper.paintChildren(graphics);
	}
}