/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import org.eclipse.draw2d.Graphics;
import org.maskat.framework.screendef.PopupDef;

public class PopupFigure extends MaskatLabel {

	private PopupDef theDef;

	public PopupFigure(PopupDef def) {
		theDef = def;
	}

	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);

		graphics.drawText(theDef.getTitle(), 0, 0);
		graphics.drawLine(0, 20, bounds.width, 20);

		graphics.translate(-bounds.x, -bounds.y);
	}
}
