/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.screendef.GridCellComboDef;
import org.maskat.ide.property.descriptor.IPropertyIDConstants;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class GridCellComboProperty extends GridCellComboDef implements IPropertySource,
		IPropertyIDConstants {

	public GridCellComboProperty() {
	}

	public Object getEditableValue() {
		return this;
	}

	private static final IPropertyDescriptor[] descriptor = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_VALUE, "value"),
			new MaskatTextPropertyDescriptor(PROP_TEXT, "text") };

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptor;
	}

	public Object getPropertyValue(Object id) {
		if (PROP_VALUE.equals(id))
			return this.getValue();
		if (PROP_TEXT.equals(id))
			return this.getText();
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if (PROP_VALUE.equals(id))
			this.setValue((String) value);
		if (PROP_TEXT.equals(id))
			this.setText((String) value);

	}

	public String toString() {
		return "";
	}
}
