/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;

public class AddGridHeaderCommand extends Command {
	GridDef grid;

	GridHeaderDef header;

	public AddGridHeaderCommand(GridDef grid, GridHeaderDef header) {
		this.grid = grid;
		this.header = header;
	}

	public void execute() {
		grid.addChild(header);
	}

	public void undo() {
		grid.removeChild(header);
	}

	public boolean canUndo() {
		return true;
	}
}
