/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractNumericFacetValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.SchemaDateTimeException;

public abstract class DateTimeValidator
extends AbstractNumericFacetValidator {
    private static final boolean DEBUG = false;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final short LESS_THAN = -1;
    protected static final short EQUAL = 0;
    protected static final short GREATER_THAN = 1;
    protected static final short INDETERMINATE = 2;
    protected static final int TOTAL_SIZE = 8;
    protected static final int MONTH_SIZE = 6;
    private static final int YEARMONTH_SIZE = 6;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;
    protected int[] timeZone;
    protected int fEnumSize;
    protected int fEnd;
    protected int fStart;
    protected StringBuffer fBuffer;
    protected int[] fDateValue;
    private int[] fTempDate;
    protected StringBuffer message;

    public DateTimeValidator() throws InvalidDatatypeFacetException {
        super(null, null, false);
    }

    public DateTimeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_DATETIME_FACET, 0, new Object[]{string}));
    }

    protected void checkContent(String string, Object object, Vector vector, boolean bl) throws InvalidDatatypeValueException {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void cloneDate(int[] nArray) {
        this.resetDateObj(this.fTempDate);
        int n = 0;
        while (n < 8) {
            this.fTempDate[n] = nArray[n];
            ++n;
        }
    }

    public int compare(String string, String string2) {
        return -1;
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray[7] == nArray2[7]) {
            return this.compareOrder(nArray, nArray2);
        }
        if (nArray[7] == 90) {
            this.cloneDate(nArray2);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 43;
            this.normalize(this.fTempDate);
            short s = this.compareOrder(nArray, this.fTempDate);
            this.cloneDate(nArray2);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 45;
            this.normalize(this.fTempDate);
            short s2 = this.compareOrder(nArray, this.fTempDate);
            if (s == -1 && s2 == 1 || s == 1 && s2 == -1) {
                return 2;
            }
            return s != 2 ? s : s2;
        }
        if (nArray2[7] == 90) {
            this.cloneDate(nArray);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 45;
            this.normalize(this.fTempDate);
            short s = this.compareOrder(this.fTempDate, nArray2);
            this.cloneDate(nArray);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 43;
            this.normalize(this.fTempDate);
            short s3 = this.compareOrder(this.fTempDate, nArray2);
            if (s == -1 && s3 == 1 || s == 1 && s3 == -1) {
                return 2;
            }
            return s != 2 ? s : s3;
        }
        return 2;
    }

    protected short compareOrder(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 8) {
            if (nArray[n] < nArray2[n]) {
                return -1;
            }
            if (nArray[n] > nArray2[n]) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    protected int compareValues(Object object, Object object2) {
        return this.compareDates((int[])object, (int[])object2, true);
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        int n = 1;
        if (nArray[0] < 0) {
            this.message.append('-');
            n = -1;
        }
        this.message.append(n * nArray[0]);
        this.message.append('-');
        this.message.append(n * nArray[1]);
        this.message.append('-');
        this.message.append(n * nArray[2]);
        this.message.append('T');
        this.message.append(n * nArray[3]);
        this.message.append(':');
        this.message.append(n * nArray[4]);
        this.message.append(':');
        this.message.append(n * nArray[5]);
        this.message.append('.');
        this.message.append(n * nArray[6]);
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }

    protected int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    protected int fQuotient(int n, int n2, int n3) {
        return this.fQuotient(n - n2, n3 - n2);
    }

    protected int findUTCSign(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = this.fBuffer.charAt(n3);
            if (c == 'Z' || c == '+' || c == '-') {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void getDate(int n, int n2, int[] nArray) throws RuntimeException {
        this.getYearMonth(n, n2, nArray);
        int n3 = this.fStart + 6;
        nArray[2] = this.parseInt(n3 - 2, n3);
    }

    protected String getMaxExclusive(boolean bl) {
        return bl ? this.dateToString((int[])((DateTimeValidator)this.fBaseValidator).fMaxExclusive) : this.dateToString((int[])this.fMaxExclusive);
    }

    protected String getMaxInclusive(boolean bl) {
        return bl ? this.dateToString((int[])((DateTimeValidator)this.fBaseValidator).fMaxInclusive) : this.dateToString((int[])this.fMaxInclusive);
    }

    protected String getMinExclusive(boolean bl) {
        return bl ? this.dateToString((int[])((DateTimeValidator)this.fBaseValidator).fMinExclusive) : this.dateToString((int[])this.fMinExclusive);
    }

    protected String getMinInclusive(boolean bl) {
        return bl ? this.dateToString((int[])((DateTimeValidator)this.fBaseValidator).fMinInclusive) : this.dateToString((int[])this.fMinInclusive);
    }

    protected void getTime(int n, int n2, int[] nArray) throws RuntimeException {
        nArray[3] = this.parseInt(n, n + 2);
        nArray[4] = this.parseInt(n += 3, n + 2);
        nArray[5] = this.parseInt(n += 3, n + 2);
        int n3 = this.indexOf(n, n2, '.');
        int n4 = this.findUTCSign(n3 != -1 ? n3 : n, n2);
        if (n3 != -1) {
            nArray[6] = n4 < 0 ? this.parseInt(n3 + 1, this.fEnd) : this.parseInt(n3 + 1, n4);
        }
        if (n4 > 0) {
            this.getTimeZone(nArray, n4);
        }
    }

    protected void getTimeZone(int[] nArray, int n) throws RuntimeException {
        nArray[7] = this.fBuffer.charAt(n);
        if (this.fBuffer.charAt(n) == 'Z') {
            if (this.fEnd > ++n) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (n <= this.fEnd - 3) {
            this.timeZone[0] = this.parseInt(++n, n + 2);
            if (nArray[7] == 45) {
                this.timeZone[0] = this.timeZone[0] * -1;
            }
            if ((n += 3) + 2 <= this.fEnd) {
                this.timeZone[1] = this.parseInt(n, n + 2);
                if (nArray[7] == 45) {
                    this.timeZone[1] = this.timeZone[1] * -1;
                }
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected void getYearMonth(int n, int n2, int[] nArray) throws RuntimeException {
        int n3;
        if (this.fBuffer.charAt(0) == '-') {
            ++n;
        }
        if ((n3 = this.indexOf(n, n2, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced.");
        }
        this.fStart = n3;
        nArray[0] = this.parseInt(n, n3);
        n = ++n3;
        nArray[1] = this.parseInt(n, n + 2);
    }

    protected int indexOf(int n, int n2, char c) {
        int n3 = n;
        while (n3 < n2) {
            if (this.fBuffer.charAt(n3) == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void initializeValues() {
        this.fDateValue = new int[8];
        this.fTempDate = new int[8];
        this.fEnd = 30;
        this.fStart = 0;
        this.message = new StringBuffer(8);
        this.fBuffer = new StringBuffer(this.fEnd);
        this.timeZone = new int[2];
    }

    private boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    protected int maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (this.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    protected int mod(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    protected int modulo(int n, int n2, int n3) {
        int n4 = n - n2;
        int n5 = n3 - n2;
        return this.mod(n4, n5, this.fQuotient(n4, n5)) + n2;
    }

    protected void normalize(int[] nArray) {
        int n = 1;
        if (nArray[7] == 43) {
            n = -1;
        }
        int n2 = nArray[4] + n * this.timeZone[1];
        int n3 = this.fQuotient(n2, 60);
        nArray[4] = this.mod(n2, 60, n3);
        n2 = nArray[3] + n * this.timeZone[0] + n3;
        n3 = this.fQuotient(n2, 24);
        nArray[3] = this.mod(n2, 24, n3);
        nArray[2] = nArray[2] + n3;
        while (nArray[2] > (n2 = this.maxDayInMonthFor(nArray[0], nArray[1]))) {
            nArray[2] = nArray[2] - n2;
            n3 = 1;
            n2 = nArray[1] + n3;
            nArray[1] = this.modulo(n2, 1, 13);
            nArray[0] = nArray[0] + this.fQuotient(n2, 1, 13);
        }
        nArray[7] = 90;
    }

    protected abstract int[] parse(String var1, int[] var2) throws SchemaDateTimeException;

    protected int parseInt(int n, int n2) throws NumberFormatException {
        int n3 = 10;
        int n4 = 0;
        int n5 = 0;
        int n6 = -2147483647;
        int n7 = n6 / n3;
        int n8 = n;
        do {
            if ((n5 = Character.digit(this.fBuffer.charAt(n8), n3)) < 0) {
                throw new NumberFormatException();
            }
            if (n4 < n7) {
                throw new NumberFormatException();
            }
            if ((n4 *= n3) < n6 + n5) {
                throw new NumberFormatException();
            }
            n4 -= n5;
        } while (++n8 < n2);
        return -n4;
    }

    protected void parseTimeZone(int n, int[] nArray) throws RuntimeException {
        int n2 = this.fStart + 6;
        if (n2 < this.fEnd) {
            int n3 = this.findUTCSign(n2, this.fEnd);
            if (n3 < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(nArray, n3);
        }
    }

    protected void reportError(String string, String string2) {
        System.err.println("[Error]: " + string + ": Value  '" + string2 + "' is not legal for current datatype");
    }

    protected void resetBuffer(String string) {
        this.fBuffer.setLength(0);
        this.fEnd = 0;
        this.fStart = 0;
        this.timeZone[1] = 0;
        this.timeZone[0] = 0;
        this.fBuffer.append(string);
        this.fEnd = this.fBuffer.length();
    }

    protected void resetDateObj(int[] nArray) {
        int n = 0;
        while (n < 8) {
            nArray[n] = 0;
            ++n;
        }
    }

    protected void setEnumeration(Vector vector) throws InvalidDatatypeValueException {
        if (vector != null) {
            this.fEnumSize = vector.size();
            this.fEnumeration = (Object[])new int[this.fEnumSize][];
            int n = 0;
            while (n < this.fEnumSize) {
                try {
                    this.fEnumeration[n] = this.parse((String)vector.elementAt(n), null);
                }
                catch (RuntimeException runtimeException) {
                    throw new InvalidDatatypeValueException(runtimeException.getMessage());
                }
                ++n;
            }
        }
    }

    protected void setMaxExclusive(String string) {
        this.fMaxExclusive = this.parse(string, null);
    }

    protected void setMaxInclusive(String string) {
        this.fMaxInclusive = this.parse(string, null);
    }

    protected void setMinExclusive(String string) {
        this.fMinExclusive = this.parse(string, null);
    }

    protected void setMinInclusive(String string) {
        this.fMinInclusive = this.parse(string, null);
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        try {
            this.resetDateObj(this.fDateValue);
            this.parse(string, this.fDateValue);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not legal value for current datatype");
        }
        this.validateDate(this.fDateValue, string);
        return null;
    }

    protected void validateDate(int[] nArray, String string) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            int n;
            if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
                throw new InvalidDatatypeValueException("Value'" + string + "' does not match regular expression facet " + this.fRegex.getPattern());
            }
            ((DateTimeValidator)this.fBaseValidator).validateDate(nArray, string);
            if ((this.fFacetsDefined & 0x10) != 0) {
                n = 0;
                boolean bl = false;
                while (n < this.fEnumSize) {
                    if (this.compareDates(nArray, (int[])this.fEnumeration[n], false) == 0) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    throw new InvalidDatatypeValueException("Value'" + string + "' does not match enumeration values");
                }
            }
            if (this.fMinInclusive != null && ((n = (int)this.compareDates(nArray, (int[])this.fMinInclusive, false)) == -1 || n == 2)) {
                throw new InvalidDatatypeValueException("Value '" + string + "' is less than minInclusive: " + this.dateToString((int[])this.fMinInclusive));
            }
            if (this.fMinExclusive != null && this.compareDates(nArray, (int[])this.fMinExclusive, true) != 1) {
                throw new InvalidDatatypeValueException("Value '" + string + "' is less than or equal to minExclusive: " + this.dateToString((int[])this.fMinExclusive));
            }
            if (this.fMaxInclusive != null && ((n = (int)this.compareDates(nArray, (int[])this.fMaxInclusive, false)) == 1 || n == 2)) {
                throw new InvalidDatatypeValueException("Value '" + string + "' is greater than maxInclusive: " + this.dateToString((int[])this.fMaxInclusive));
            }
            if (this.fMaxExclusive != null && this.compareDates(nArray, (int[])this.fMaxExclusive, true) != -1) {
                throw new InvalidDatatypeValueException("Value '" + string + "' is greater than or equal to maxExlusive: " + this.dateToString((int[])this.fMaxExclusive));
            }
        } else {
            return;
        }
    }

    protected boolean validateDateTime(int[] nArray) {
        if (nArray[0] == 0) {
            System.err.println("[Error]: The year \"0000\" is an illegal year value.");
            return false;
        }
        if (nArray[1] < 1 || nArray[1] > 12) {
            System.err.println("[Error]: The month must have values 1 to 12.");
            return false;
        }
        if (nArray[2] > this.maxDayInMonthFor(nArray[0], nArray[1])) {
            System.err.println("[Error]: The day must have values 1 to 31.");
        }
        if (nArray[3] > 23 || nArray[3] < 0) {
            System.err.println("[Error] Hour must have values 0-23.");
            return false;
        }
        if (nArray[4] > 59 || nArray[4] < 0) {
            System.err.println("[Error] Minute must have values 0-59.");
            return false;
        }
        if (nArray[5] > 60 || nArray[5] < 0) {
            System.err.println("[Error] Second must have values 0-60.");
            return false;
        }
        if (this.timeZone[0] > 14 || this.timeZone[0] < -14) {
            System.err.println("[Error] Time zone should have range -14..+14.");
            return false;
        }
        if (this.timeZone[1] > 59 || this.timeZone[1] < -59) {
            System.err.println("[Error] Minute must have values 0-59.");
            return false;
        }
        return true;
    }
}

