/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

public class NamespacesScope {
    private NamespacesHandler fHandler = null;
    private int fElementDepth = 0;
    private int[][] fNamespaceMappings = new int[8][];

    public NamespacesScope() {
        this(new NamespacesHandler(){

            public void endNamespaceDeclScope(int n) throws Exception {
            }

            public void startNamespaceDeclScope(int n, int n2) throws Exception {
            }
        });
    }

    public NamespacesScope(NamespacesHandler namespacesHandler) {
        this.fHandler = namespacesHandler;
        this.fNamespaceMappings[0] = new int[9];
        this.fNamespaceMappings[0][0] = 1;
    }

    public void decreaseDepth() throws Exception {
        if (this.fElementDepth > 0) {
            int n = this.fNamespaceMappings[this.fElementDepth][0];
            while (n > 1) {
                this.fHandler.endNamespaceDeclScope(this.fNamespaceMappings[this.fElementDepth][n -= 2]);
            }
        }
        --this.fElementDepth;
    }

    public int getNamespaceForPrefix(int n) {
        int n2 = this.fElementDepth;
        while (n2 >= 0) {
            int n3 = this.fNamespaceMappings[n2][0];
            int n4 = 1;
            while (n4 < n3) {
                if (n == this.fNamespaceMappings[n2][n4]) {
                    return this.fNamespaceMappings[n2][n4 + 1];
                }
                n4 += 2;
            }
            --n2;
        }
        return 0;
    }

    public void increaseDepth() throws Exception {
        ++this.fElementDepth;
        if (this.fElementDepth == this.fNamespaceMappings.length) {
            int[][] nArray = new int[this.fElementDepth + 8][];
            System.arraycopy(this.fNamespaceMappings, 0, nArray, 0, this.fElementDepth);
            this.fNamespaceMappings = nArray;
        }
        if (this.fNamespaceMappings[this.fElementDepth] == null) {
            this.fNamespaceMappings[this.fElementDepth] = new int[9];
        }
        this.fNamespaceMappings[this.fElementDepth][0] = 1;
    }

    public void setNamespaceForPrefix(int n, int n2) throws Exception {
        int n3 = this.fNamespaceMappings[this.fElementDepth][0];
        if (n3 == this.fNamespaceMappings[this.fElementDepth].length) {
            int[] nArray = new int[n3 + 8];
            System.arraycopy(this.fNamespaceMappings[this.fElementDepth], 0, nArray, 0, n3);
            this.fNamespaceMappings[this.fElementDepth] = nArray;
        }
        this.fNamespaceMappings[this.fElementDepth][n3++] = n;
        this.fNamespaceMappings[this.fElementDepth][n3++] = n2;
        this.fNamespaceMappings[this.fElementDepth][0] = n3;
        if (this.fElementDepth > 0) {
            this.fHandler.startNamespaceDeclScope(n, n2);
        }
    }

    public static interface NamespacesHandler {
        public void endNamespaceDeclScope(int var1) throws Exception;

        public void startNamespaceDeclScope(int var1, int var2) throws Exception;
    }
}

