/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.Layout;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.ide.property.descriptor.EventPropertyDescriptor;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class LayoutProperty extends Layout implements IPropertySource {

	private static final String PROP_ID = "_prop_id_";

	private static final String PROP_NAME = "_prop_name_";

	private static final String PROP_REMOTEURL = "_prop_remoteurl_";

	private static final String PROP_ONLOAD = "_prop_onload_";

	private static final String PROP_REFPARENTHTML = "_prop_refparenthtml_";

	private static final IPropertyDescriptor[] descriptor = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_ID, "id"),
			new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
			new MaskatTextPropertyDescriptor(PROP_REMOTEURL, "remoteUrl"),
			new EventPropertyDescriptor(PROP_ONLOAD, "onload"),
			new MaskatTextPropertyDescriptor(PROP_REFPARENTHTML, "refParentHTML") };

	private LayoutDef layoutDef;

	public LayoutDef getLayoutDef() {
		return layoutDef;
	}

	public void setLayoutDef(LayoutDef layoutDef) {
		this.layoutDef = layoutDef;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptor;
	}

	public Object getPropertyValue(Object id) {
		Object result = doGetPropertyValue(id);
		if (result == null)
			return "";
		return result;
	}

	public Object doGetPropertyValue(Object id) {
		if (PROP_ID.equals(id)) {
			return getId();
		}
		if (PROP_REMOTEURL.equals(id)) {
			return getRemoteUrl();
		}
		if (PROP_ONLOAD.equals(id)) {
			this.findEvent("onload");
		}
		if (PROP_REFPARENTHTML.equals(id)) {
			return this.getLayoutDef().getRefParentHTML();
		}
		if (PROP_NAME.equals(id)) {
			return this.getLayoutDef().getName();
		}
		if (PROP_ONLOAD.equals(id)) {
			EventProperty evtProperty = (EventProperty) findEvent("onload");
			if (evtProperty != null) {
				if (evtProperty.isEnable())
					return evtProperty;
				return String.valueOf(evtProperty);
			}
			return EventPropertyDescriptor.EVENT_OFF_DISP;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if ("".equals(value)) {
			value = null;
			// PropertySourceɋ󔒕nȂ悤
			// xml name="" ̂悤attributeo͂Ȃ悤
		}
		doSetPropertyValue(id, value);
	}

	public void doSetPropertyValue(Object id, Object value) {
		if (PROP_ID.equals(id)) {
			setId((String) value);
		}
		if (PROP_REMOTEURL.equals(id)) {
			setRemoteUrl((String) value);
		}
		if (PROP_REFPARENTHTML.equals(id)) {
			this.getLayoutDef().setRefParentHTML((String) value);
		}
		if (PROP_NAME.equals(id)) {
			this.getLayoutDef().setName((String) value);
		}
		if (value instanceof String && PROP_ONLOAD.equals(id)) {
			String eventId = "onload";
			Event event = findEvent(eventId);
			if (event != null && !(event instanceof EventProperty)) {
				throw new IllegalArgumentException("event̃^CvEventPropertył͂܂B");
			}
			EventProperty evtProperty = (EventProperty) event;
			if (evtProperty == null) {
				evtProperty = new EventProperty();
				evtProperty.setId(eventId);
				evtProperty.addChild(new ParamProperty());
				evtProperty.addChild(new ResultProperty());

				addChild(evtProperty);
			}
			if (EventPropertyDescriptor.EVENT_ON_DISP.equals(value)) {
				evtProperty.setEnable(true);
			} else {
				evtProperty.setEnable(false);
			}
		}
	}

}
