/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import org.eclipse.gef.EditPart;

/**
 * Content factory for customized component. Instances of this interface is
 * responsible for providing IPluginComponentDef (gef's model) and EditPart for
 * the extended component. Instance is specified by the class attribute of the
 * contentFactory element in the plugin.xml.
 * 
 * The default IPluginComponentDef and EditPart will be used if this factory
 * returns no instance(null).
 * 
 * @author shengshen
 */
public interface IContentFactory {

	/**
	 * If returns null, then the default implementation will be used.
	 * PluginComponentDef or PluginContainerDer depending on the "isContainer"
	 * attribute.
	 * 
	 * @param proxy
	 * @return
	 */
	public IPluginComponentDef newDef(PluginDefProxy proxy);

	/**
	 * 
	 * @return
	 */
	public EditPart newEditPart();
}