/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.xml;

import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.Serializer;
import org.exolab.castor.xml.XMLSerializerFactory;
import org.exolab.castor.xml.XercesSerializer;

public class MaskatSerializerFactory implements XMLSerializerFactory {

	public Serializer getSerializer() {
		return new XercesSerializer();
	}

	public OutputFormat getOutputFormat() {
		MaskatOutputFormatForCastor format = new MaskatOutputFormatForCastor();
		Object innerFormat = format.getFormat();
		if (innerFormat instanceof org.apache.xml.serialize.OutputFormat) {
			((org.apache.xml.serialize.OutputFormat) innerFormat)
					.setLineWidth(0);// s̒Ȃ
			((org.apache.xml.serialize.OutputFormat) innerFormat)
					.setCDataElements(new String[] { "desc",
							"javaScript", "javaScriptGlobal" });
			((org.apache.xml.serialize.OutputFormat) innerFormat)
					.setNonEscapingElements(new String[] { "desc",
							"javaScript", "javaScriptGlobal" });
			// desc^ÕeLXgCDATAƂĈisłj
		}

		return format;
	}

}
