/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property.descriptor;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.eventdef.Header;

public class DeleteHeaderCommand extends Command {
	private int idxInParent;

	private Header header;

	private IBasicDef parentDef;

	public DeleteHeaderCommand(Header header) {
		if (header == null) {
			throw new IllegalArgumentException("parameter [header] is null.");
		}
		this.setLabel("event`header`폜");
		this.header = header;
		parentDef = header.getParentDef();
		idxInParent = parentDef.getChildIdx(header);
		if (idxInParent == -1)
			throw new IllegalArgumentException(
					"[header] is not a child of its parentDef property.");

	}

	public void execute() {
		parentDef.removeChild(header);
	}

	public boolean canUndo() {
		return true;
	}

	public void undo() {
		parentDef.addChildToIdx(header,idxInParent);
	}
}
