/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.eventdef.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.digester.Digester;
import org.maskat.framework.eventdef.Bind;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.EventRef;
import org.maskat.framework.eventdef.Header;
import org.maskat.framework.eventdef.Layout;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.RemoteUrl;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.eventdef.Source;
import org.maskat.framework.eventdef.Target;
import org.maskat.ide.property.ComponentProperty;
import org.maskat.ide.property.LayoutProperty;
import org.maskat.xml.digester.MaskatDigester;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EventDefParser {
	public static Layout parse(InputStream input) throws IOException, SAXException {
		Layout result = null;
		Digester digester = new MaskatDigester();

		digester.setValidating(false);
		digester.setNamespaceAware(true);

		digester.addObjectCreate("eventDef", null, LayoutProperty.class);
		digester.addSetProperties("eventDef");

		digester.addCallMethod("*/desc", "addDesc", 0);

		digester.addObjectCreate("*/remoteUrl", RemoteUrl.class);
		digester.addSetProperties("*/remoteUrl", "url", "url");
		digester.addSetNext("*/remoteUrl", "addChild", RemoteUrl.class.getName());

		digester.addObjectCreate("*/header", Header.class);
		digester.addSetProperties("*/header");
		digester.addSetNext("*/header", "addChild", Header.class.getName());

		digester.addObjectCreate("*/eventDef/eventRef", EventRef.class);
		digester.addSetProperties("*/eventDef/eventRef", "id", "refid");
		digester.addSetNext("*/eventDef/eventRef", "addChild", EventRef.class.getName());

		digester.addObjectCreate("*/eventDef/event", Event.class);
		digester.addSetProperties("*/eventDef/event");
		digester.addSetNext("*/eventDef/event", "addChild", Event.class.getName());

		digester.addObjectCreate("*/eventDef/component", ComponentProperty.class);
		digester.addSetProperties("*/eventDef/component");
		digester.addSetNext("*/eventDef/component", "addChild", ComponentProperty.class
				.getName());

		digester.addObjectCreate("*/eventDef/component/event", Event.class);
		digester.addSetProperties("*/eventDef/component/event", "id", "id");
		digester.addSetNext("*/eventDef/component/event", "addChild", Event.class
				.getName());

		digester.addObjectCreate("*/param", Param.class);
		digester.addSetProperties("*/param");
		digester.addSetNext("*/param", "addChild", Param.class.getName());

		digester.addObjectCreate("*/param/source", Source.class);
		digester.addSetProperties("*/param/source");
		digester.addSetNext("*/param/source", "addChild", Source.class.getName());

		digester.addObjectCreate("*/bind", Bind.class);
		digester.addSetProperties("*/bind");
		digester.addSetNext("*/bind", "addChild", Bind.class.getName());

		digester.addObjectCreate("*/result", Result.class);
		digester.addSetProperties("*/result");
		digester.addSetNext("*/result", "addChild", Result.class.getName());

		digester.addObjectCreate("*/result/target", Target.class);
		digester.addSetProperties("*/result/target");
		digester.addSetNext("*/result/target", "addChild", Target.class.getName());

		result = (Layout) digester.parse(input);

		result.prepareEvent();

		return result;
	}

	/** XL[}邽߂̃CX^Xɓ]pxsltAevf̃eLXglƂĂ͗vf̃^CvłBႦ΁F&lt;data&gt;xs:int&lt;/data&gt; */
	public static final String EVENTDEF_XSLT_FOR_SCHEMA_GEN = "org/maskat/framework/eventdef/xml/ruleSplitByTele.xsl";

	/** XL[}؂邽߂̃CX^Xɓ]pxsltAevf̃eLXglƂĂ͗vf̒lłBႦ΁F&lt;data&gt;1&lt;/data&gt; */
	public static final String EVENTDEF_XSLT_FOR_INSTANCE = "org/maskat/framework/eventdef/xml/toTeleInstance.xsl";

	/**
	 * Cxg`XMLdXML̃CX^X𐶐
	 * 
	 * @param stream
	 *            Cxg`XMLInputStream
	 * @param name
	 *            ]pxslt̃pX
	 * @return m[hXgASendTeleRecvTelem[h̃Xg
	 * @throws TransformerException
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws IOException
	 */
	public static NodeList genTeleInstanceFromEventDef(InputStream stream, String name)
			throws TransformerException, ParserConfigurationException, SAXException,
			IOException {

		// TransformerFactoryCX^X擾
		TransformerFactory factory = TransformerFactory.newInstance();

		// XSLt@Ctranceformer擾
		InputStream ruleStream = EventDefParser.class.getClassLoader()
				.getResourceAsStream(name);
		Transformer transformer = factory.newTransformer(new StreamSource(ruleStream));
		// o͂GR[fBOݒ
		transformer.setOutputProperty("encoding", "UTF-8");

		// ʂi[pDOMResult
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = dbFactory.newDocumentBuilder();
		Document doc = builder.parse(new ByteArrayInputStream("<result></result>"
				.getBytes()));
		DOMResult dr = new DOMResult(doc.getDocumentElement());

		XMLReader rdr = XMLReaderFactory.createXMLReader();
		rdr.setEntityResolver(new EntityResolver() {
			public InputSource resolveEntity(String publicId, String systemId)
					throws SAXException, IOException {
				return new InputSource(new StringReader(""));
			}
		});

		// XMLt@CXSLTŕϊďo
		transformer.transform(new SAXSource(rdr, new InputSource(stream)), dr);
		return dr.getNode().getChildNodes();
	}
}
