/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class PopupDefBeanInfo extends SimpleBeanInfo {
	public PropertyDescriptor[] getPropertyDescriptors() {
		PropertyDescriptor[] descs = null;
		PropertyDescriptor[] PopupDefPropDesc = null;
		// PopupDef̐eNXBeanInfo
		try {
			BeanInfo info = Introspector.getBeanInfo(ComponentDef.class);
			descs = info.getPropertyDescriptors();
			PopupDefPropDesc = new PropertyDescriptor[] {
					new PropertyDescriptor("title", PopupDef.class),
					new PropertyDescriptor("contenu", PopupDef.class),
					new PropertyDescriptor("modeContainer", PopupDef.class),
					new PropertyDescriptor("bSansBtonClose", PopupDef.class),
					new PropertyDescriptor("suffFond", PopupDef.class) };
		} catch (IntrospectionException e) {
			return null;
		}

		// PopupDefgPropertyDescriptor[]ǉ
		PropertyDescriptor[] result = new PropertyDescriptor[descs.length
				+ PopupDefPropDesc.length];
		System.arraycopy(descs, 0, result, 0, descs.length);
		System.arraycopy(PopupDefPropDesc, 0, result, descs.length,
				PopupDefPropDesc.length);
		return result;
	}

}
