/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.Iterator;

public class TreeNodeDef extends ComponentDef {
	private String sText;

	private String sIcon;

	private String sIcon2;

	private String open;

	private String reload;

	private String url;

	private String typeInfo;

	private String onclick;

	private int layer;

	/** c[̍D՗CfbNX */
	private int leftIterationIndex;

	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}

	public void addChild(Object obj) {
		super.addChild(obj);
		firePropertyChange("addChild", "", null);
	}

	public void addChildToIdx(Object child, int idx) {
		super.addChildToIdx(child, idx);
		firePropertyChange("addChild", "", null);
	}

	/**
	 * 
	 * @param nextIndex
	 * @return nextIndex
	 */
	public int travel(int nextIndex) {
		this.leftIterationIndex = nextIndex++;
		for (Iterator it = this.getTypedChildren(TreeNodeDef.class); it != null
				&& it.hasNext();) {
			TreeNodeDef def = (TreeNodeDef) it.next();
			def.setLayer(layer + 1);
			nextIndex = def.travel(nextIndex);
		}
		return nextIndex;
	}

	public int getLayer() {
		return layer;
	}

	public void setLayer(int layer) {
		this.layer = layer;
	}

	public int getLeftIterationIndex() {
		return leftIterationIndex;
	}

	public void setLeftIterationIndex(int leftIterationIndex) {
		this.leftIterationIndex = leftIterationIndex;
	}

	public String getSIcon() {
		return sIcon;
	}

	public void setSIcon(String icon) {
		this.sIcon = icon;
	}

	public String getSIcon2() {
		return sIcon2;
	}

	public void setSIcon2(String icon2) {
		this.sIcon2 = icon2;
	}

	public String getOnclick() {
		return onclick;
	}

	public void setOnclick(String onclick) {
		this.onclick = onclick;
	}

	public String getOpen() {
		return open;
	}

	public void setOpen(String open) {
		this.open = open;
	}

	public String getReload() {
		return reload;
	}

	public void setReload(String reload) {
		this.reload = reload;
	}

	public String getSText() {
		return sText;
	}

	public void setSText(String sText) {
		firePropertyChange("sText", this.sText, sText);
		this.sText = sText;
	}

	public String getTypeInfo() {
		return typeInfo;
	}

	public void setTypeInfo(String typeInfo) {
		this.typeInfo = typeInfo;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

}
