/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import org.maskat.framework.screendef.ComponentDef;

class PluginComponentDef extends ComponentDef implements IPluginComponentDef {
	private PluginDefProxy proxy;

	private DefaultPluginComponentAdapter adapter;

	PluginComponentDef(IComponentPluginConfig config, String prefix) {
		this.proxy = new PluginDefProxy(config, prefix);
		adapter = new DefaultPluginComponentAdapter(this);
	}

	public PluginDefProxy getProxy() {
		return proxy;
	}

	public String getAttribute(String key) {
		return adapter.getAttribute(key);
	}

	public void setAttribute(String key, String value) {
		// TODO check if key is defined in the config
		// if key is the ComponentDef's property, then directly set the
		// value of ComponentDef
		adapter.setAttribute(key, value);
	}

}