/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.maskat.framework.screendef.TreeNodeDef;
import org.maskat.ide.gef.editpolicies.TreeNodeComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.TreeNodeXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.MaskatLabel;

public class TreeNodeEditPart extends ComponentEditPart {
	protected IFigure createFigure() {
		TreeNodeDef def = (TreeNodeDef) getModel();

		Label label = new MaskatLabel(def.getSText());
		label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(2)));
		label.setOpaque(false);
		label.setFont(DEFAULT_FONT);

		XYLayout layout = new XYLayout();
		label.setLayoutManager(layout);
		return label;
	}

	protected List getModelChildren() {
		return Collections.EMPTY_LIST;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new TreeNodeXYLayoutEditPolicy());
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new TreeNodeComponentEditPolicy());
	}

	protected void refreshVisuals() {
		Dimension dim = figure.getPreferredSize();
		TreeNodeDef def = (TreeNodeDef) getModel();
		Rectangle constraint = new Rectangle(12 * def.getLayer(), 20 * def
				.getLeftIterationIndex(), dim.width, 20);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("sText".equals(evt.getPropertyName())) {
			((Label) getFigure()).setText((String) evt.getNewValue());
			getFigure().repaint();
			refreshVisuals();
		}
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			EditPart parent = this.getParent();
			while (!(parent instanceof TreeViewEditPart || parent instanceof RootEditPart)) {
				parent = parent.getParent();
			}
			if (parent instanceof TreeViewEditPart) {
				((TreeViewEditPart) parent).forceRefresh();
			}
		}
	}

	public void forceRefresh() {
		refresh();
		// ׂĂ̎qm[htbV
		for (Iterator it = this.getChildren().iterator(); it.hasNext();) {
			((EditPart) it.next()).refresh();
		}
	}
}
