/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.TabItemDef;

public class TabDef {

	private IContainerDef parent;

	private TabItemDef tabItemDef;

	public TabDef(IContainerDef parent, TabItemDef tabItemDef) {
		this.parent = parent;
		this.tabItemDef = tabItemDef;
	}

	public String getName() {
		return tabItemDef.getName();
	}

	public void setName(String name) {
		tabItemDef.setName(name);
	}

	public IContainerDef getParent() {
		return parent;
	}

	public void setParent(IContainerDef parent) {
		this.parent = parent;
	}

	public String getTitle() {
		return tabItemDef.getTitle();
	}

	public void setTitle(String title) {
		firePropertyChange("title", tabItemDef.getTitle(), title);
		tabItemDef.setTitle(title);
	}

	// f̏ԕωʒm郊XĩXg
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener l) {
		listeners.addPropertyChangeListener(l);
	}

	protected void firePropertyChange(String propName, Object oldValue,
			Object newValue) {
		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	public void removePropertyChangeListener(PropertyChangeListener l) {
		listeners.removePropertyChangeListener(l);
	}
}
