/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.editors.MaskatTextEditor;

public class MaskatPropertySheetPage extends PropertySheetPage {

	public MaskatPropertySheetPage() {
		super();
		this.setSorter(inst);
	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (part instanceof MaskatEditor) {
			MaskatEditor maskatEditor = (MaskatEditor) part;
			if (maskatEditor.editMode == MaskatEditor.SCREEN_EDIT_MODE) {
				super.selectionChanged(part, selection);
				maskatEditor.setLastSelectionForEdit(selection);
			}
		} else if (part instanceof MaskatEditView) {
			super.selectionChanged(part, selection);
		} else {
			if (part instanceof MaskatTextEditor) {
				return;// MaskatTextEditorł΁AȂB
			}
			// 󔒕\
			super.selectionChanged(part, StructuredSelection.EMPTY);
		}
	}

	private static List names = new ArrayList();
	static {
		names.add("name");
		names.add("left");
		names.add("top");
		names.add("width");
		names.add("height");
	}

	private static PropertySheetSorter inst = new MaskatPropertySheetSorter();

	private static class MaskatPropertySheetSorter extends PropertySheetSorter {

		private int getIndex(String str) {
			int idx = names.indexOf(str);
			if (idx >= 0) {
				return idx;
			}
			return Integer.MAX_VALUE;
		}

		public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
			int idxA = getIndex(entryA.getDisplayName());
			int idxB = getIndex(entryB.getDisplayName());

			return idxA - idxB;
		}
	}
}