/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view.edit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Table;

public class TableKeyListener extends KeyAdapter {
	private Table theTable;

	public static KeyAdapter bindTableKeyListener(Table table) {
		return new TableKeyListener(table);
	}

	public TableKeyListener(Table table) {
		if (table == null || table.isDisposed()) {
			throw new IllegalArgumentException("table is null or disposed");
		}
		theTable = table;
		theTable.addKeyListener(this);
	}

	public void keyReleased(KeyEvent e) {
		if (theTable.isDisposed()) {
			return;
		}
		if (e.keyCode == SWT.DEL) {
			// Jgs폜
			int index = theTable.getSelectionIndex();
			if (index == -1)
				return;
			theTable.remove(index);
			theTable.select(Math.min(theTable.getItemCount() - 1, index));
		}
	}
}
