/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.wizards;

public class HtmlContainerParam {
	private String title;

	private String maskatFWPath;

	private String layoutFileName;

	private String eventFileName;

	private int width;

	private int height;

	public String getEventFileName() {
		return encode(eventFileName);
	}

	public void setEventFileName(String eventFileName) {
		this.eventFileName = eventFileName;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public String getLayoutFileName() {
		return encode(layoutFileName);
	}

	public void setLayoutFileName(String layoutFileName) {
		this.layoutFileName = layoutFileName;
	}

	public String getMaskatFWPath() {
		return encode(maskatFWPath);
	}

	public void setMaskatFWPath(String maskatFWPath) {
		this.maskatFWPath = maskatFWPath;
	}

	public String getTitle() {
		return encode(title);
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	private String encode(String value) {
		return value.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"",
				"&quot;");
	}
}
