/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.PopupDef;

public class ChangeConstraintCommand extends Command {
	private IComponentDef nodeElement;

	private Rectangle newConstraint, oldConstraint;

	public ChangeConstraintCommand(IComponentDef node, Rectangle newConstraint) {
		super(node.getName() + "̈ʒuATCYύX");
		nodeElement = node;
		this.newConstraint = newConstraint;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		doExecute();
	}

	private void doExecute() {
		// ̕ύX
		if (nodeElement instanceof DivSplitDef) {
			// łnewConstraint.height邢widthDivSplitDefheightwidthł
			// parentSplitterDefheightwidthł͂Ȃ
			// AnodeElement̑΍WωvZāASplitterDef̍WvZ

			int deltaX = newConstraint.x - nodeElement.getLeft();
			int deltaY = newConstraint.y - nodeElement.getTop();
			int deltaWidth = newConstraint.width - nodeElement.getWidth();
			int deltaHeight = newConstraint.height - nodeElement.getHeight();

			IContainerDef parent = nodeElement.getParent();
			if (parent.getParent() instanceof PopupDef) {
				deltaY = (parent.getTop() + deltaY) < 0 ? -parent.getTop() : deltaY;
			}
			//
			this.oldConstraint = new Rectangle(parent.getLeft(), parent.getTop(), parent
					.getWidth(), parent.getHeight());
			parent.setConstraint(parent.getLeft() + deltaX, parent.getTop() + deltaY,
					parent.getWidth() + deltaWidth, parent.getHeight() + deltaHeight);
		} else {
			int targetY = newConstraint.y;
			if (nodeElement.getParent() instanceof PopupDef) {
				targetY -= 20;
				targetY = Math.max(0, targetY);
			}
			this.oldConstraint = new Rectangle(nodeElement.getLeft(), nodeElement
					.getTop(), nodeElement.getWidth(), nodeElement.getHeight());
			nodeElement.setConstraint(newConstraint.x, targetY, newConstraint.width,
					newConstraint.height);
		}
	}

	public boolean canUndo() {
		return true;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		// ɂǂ

		if (nodeElement instanceof DivSplitDef) {
			nodeElement.getParent().setConstraint(oldConstraint.x, oldConstraint.y,
					oldConstraint.width, oldConstraint.height);
		} else {
			nodeElement.setConstraint(oldConstraint.x, oldConstraint.y,
					oldConstraint.width, oldConstraint.height);
		}
	}

}
