/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Font;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.ComboItemDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.ide.gef.editpolicies.ComboItemEditPolicy;
import org.maskat.ide.gef.figure.ComboItemLabel;

public class ComboItemEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {

	public final static int DEFAULT_HEIGHT = 20;

	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	public void activate() {
		this.addEditPartListener(new EditPartListener.Stub() {
			public void selectedStateChanged(EditPart part) {
				IBasicDef comboDef = ((ComboItemDef) ComboItemEditPart.this.getModel())
						.getParentDef();
				if (comboDef.getChildIdx(ComboItemEditPart.this.getModel()) == -1)
					return;// The comboItem has been removed from the parent,
				// so don't refresh here.
				// One refresh of editpart here will remove the editpart of
				// comboitem from combo's, which should be the job of the
				// DelComboItemCommand.
				if (part.getSelected() == SELECTED_NONE) {
					((ComboboxEditPart) ComboItemEditPart.this.getParent())
							.setShowChildren(false);
				} else {
					((ComboboxEditPart) ComboItemEditPart.this.getParent())
							.setShowChildren(true);
				}
				super.selectedStateChanged(part);
			}
		});
		IComponentDef model = (IComponentDef) getModel();
		model.addPropertyChangeListener(this);
		super.activate();
	}

	public void deactivate() {
		IComponentDef model = (IComponentDef) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected IFigure createFigure() {
		ComboItemDef ci = (ComboItemDef) getModel();
		ComboItemLabel label = new ComboItemLabel(ci.getText());
		label.setFont(DEFAULT_FONT);
		XYLayout layout = new XYLayout();
		label.setLayoutManager(layout);
		return label;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new ComboItemEditPolicy());
	}

	protected void refreshVisuals() {
		ComboItemDef ci = (ComboItemDef) getModel();
		((Label) getFigure()).setText(ci.getText());

		ComboboxEditPart ce = (ComboboxEditPart) this.getParent();
		ComboDef comboDef = (ComboDef) ce.getModel();
		Rectangle constraint = new Rectangle();

		int height = Math.max(comboDef.calcHeightItemInt(),
				ComboboxEditPart.MIN_HEIGHT_ITEM);
		int idx = comboDef.getChildIdx(this.getModel());
		constraint.setLocation(0, DEFAULT_HEIGHT + idx * height);

		constraint.setSize(figure.getPreferredSize().width, height - 1);

		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}
}