/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.maskat.ide.gef.editparts.ComboItemEditPart;
import org.maskat.ide.gef.editparts.ComponentEditPart;
import org.maskat.ide.gef.editparts.GridHeaderEditPart;
import org.maskat.ide.gef.editparts.SplitEditPart;
import org.maskat.ide.gef.editparts.SplitPageEditPart;
import org.maskat.ide.gef.editparts.TabEditPart;
import org.maskat.ide.gef.editparts.TabFolderEditPart;

public class PropertySourceProviderForEditPart implements IPropertySourceProvider {

	public static IPropertySourceProvider ins = new PropertySourceProviderForEditPart();

	public IPropertySource getPropertySource(Object object) {
		if (object instanceof ComponentEditPart) {
			// MaskatEditPartł΁Aobject.getAdapter(IPropertySource.class)Ăׂ
			// nullԋp邩AmodelIPropertySource.classadapter
			AbstractGraphicalEditPart part = (AbstractGraphicalEditPart) object;
			return (IPropertySource) Platform.getAdapterManager().getAdapter(
					part.getModel(), IPropertySource.class);
		}
		if (object instanceof GridHeaderEditPart || object instanceof SplitPageEditPart
				|| object instanceof SplitEditPart || object instanceof TabFolderEditPart
				|| object instanceof TabEditPart || object instanceof ComboItemEditPart) {
			AbstractGraphicalEditPart part = (AbstractGraphicalEditPart) object;
			return (IPropertySource) Platform.getAdapterManager().getAdapter(
					part.getModel(), IPropertySource.class);
		}
		if (object instanceof IPropertySource) {
			return (IPropertySource) object;
		}
		return null;
	}
}
