/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property.descriptor;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.IBasicDef;

public class DeleteChildCommand extends Command {
	private int idxInParent;

	private IBasicDef child;

	private IBasicDef parentDef;

	public DeleteChildCommand(IBasicDef child) {
		if (child == null) {
			throw new IllegalArgumentException("parameter [child] is null.");
		}
		this.setLabel("e`m[hɎq`m[h폜");
		this.child = child;
		parentDef = child.getParentDef();
		idxInParent = parentDef.getChildIdx(child);
		if (idxInParent == -1)
			throw new IllegalArgumentException(
					"[child] is not a child of its parentDef property.");

	}

	public void execute() {
		parentDef.removeChild(child);
	}

	public boolean canUndo() {
		return true;
	}

	public void undo() {
		parentDef.addChildToIdx(child, idxInParent);
	}
}
