/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.xml.digester;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.digester.Digester;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MaskatDigester extends Digester {
	private Map namespaceMap = new HashMap();

	public MaskatDigester() {
		super();
	}

	public void startPrefixMapping(String prefix, String namespaceURI)
			throws SAXException {
		super.startPrefixMapping(prefix, namespaceURI);
		namespaceMap.put(namespaceURI, prefix);
	}

	public XMLReader getXMLReader() throws SAXException {
		XMLReader reader = super.getXMLReader();
		reader.setEntityResolver(new EntityResolver() {
			public InputSource resolveEntity(String publicId, String systemId)
					throws SAXException, IOException {
				return new InputSource(new StringReader(""));
			}
		});
		return reader;
	}

	/**
	 * }bṽL[namespaceURIAvalueprefix
	 * 
	 * @return
	 */
	public Map getNamespaceMap() {
		return namespaceMap;
	}

	public void addSetLayoutProperties(String pattern) {
		super.addSetProperties(pattern, new String[] { "parent", "constraint" },
				new String[] { "attrParent", "attrConstraint" });
	}
}
