/*
 * mcu_tim.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_MDR32F9QX_MCU_TIM_H_
#define HAL_MDR32F9QX_MCU_TIM_H_

#include <stdint.h>
#include <MDR32F9Qx_config.h>
#include <MDR32F9Qx_timer.h>

#define TIM1                MDR_TIMER1
#define TIM2                MDR_TIMER2
#define TIM3                MDR_TIMER3

#define TIM1_IRQHandler     Timer1_IRQHandler
#define TIM2_IRQHandler     Timer2_IRQHandler
#define TIM3_IRQHandler     Timer3_IRQHandler

#ifdef TIMER_CNTRL_FDTS_TIM_CLK
// так определю наличие библиотеки v1.4.2
#define MDRSPL_142
#else
// официальная библииотека Миландра не имеет многого из версии v1.4.2
/* FDTS Modes */
#define TIMER_CNTRL_FDTS_TIM_CLK                0x00
#define TIMER_CNTRL_FDTS_SECOND_TIM_CLK         0x01
#define TIMER_CNTRL_FDTS_THIRD_TIM_CLK          0x02
#define TIMER_CNTRL_FDTS_FOURTH_TIM_CLK         0x03

/* CNT Modes*/
#define TIMER_CNTRL_CNT_MODE_UP_DIR_0_PSG_0             0x00
#define TIMER_CNTRL_CNT_MODE_DOWN_DIR_1_PSG_0           0x00
#define TIMER_CNTRL_CNT_MODE_UP_DOWN_DIR_AUTO_PSG_0     0x01
#define TIMER_CNTRL_CNT_MODE_UP_DIR_0_EVENT_1           0x02
#define TIMER_CNTRL_CNT_MODE_DOWN_DIR_1_EVENT_1         0x02
#define TIMER_CNTRL_CNT_MODE_UP_DOWN_DIR_AUTO_EVENT_1   0x03

/* EVENT SEL Modes */
#define TIMER_CNTRL_EVENT_SEL_TIM_CLK           0x00
#define TIMER_CNTRL_EVENT_SEL_CNT_ARR_TIM1      0x01
#define TIMER_CNTRL_EVENT_SEL_CNT_ARR_TIM2      0x02
#define TIMER_CNTRL_EVENT_SEL_CNT_ARR_TIM3      0x03
#define TIMER_CNTRL_EVENT_SEL_CH1_MODE1         0x04
#define TIMER_CNTRL_EVENT_SEL_CH2_MODE1         0x05
#define TIMER_CNTRL_EVENT_SEL_CH3_MODE1         0x06
#define TIMER_CNTRL_EVENT_SEL_CH4_MODE1         0x07
#define TIMER_CNTRL_EVENT_SEL_ETR_MODE2         0x08

/* OCCM Modes */
// CCR1 EN = X
#define TIMER_CH_CNTRL_OCCM_REF_0                       0x00
#define TIMER_CH_CNTRL_OCCM_REF_1                       0x05
// CCR1 EN = 0
#define TIMER_CH_CNTRL_OCCM_REF_1_CNT_CCR               0x01
#define TIMER_CH_CNTRL_OCCM_REF_0_CNT_CCR               0x02
#define TIMER_CH_CNTRL_OCCM_SW_REF_CNT_CCR              0x03
#define TIMER_CH_CNTRL_OCCM_REF_1_DIR_0_CNT_CCR         0x06
#define TIMER_CH_CNTRL_OCCM_REF_0_DIR_1_CNT_CCR         0x06
#define TIMER_CH_CNTRL_OCCM_REF_0_DIR_0_CNT_CCR         0x07
#define TIMER_CH_CNTRL_OCCM_REF_1_DIR_1_CNT_CCR         0x07
// CCR1 EN = 1
#define TIMER_CH_CNTRL_OCCM_REF_1_CNT_CCR_OR_CNT_CCR1   0x01
#define TIMER_CH_CNTRL_OCCM_REF_0_CNT_CCR_OR_CNT_CCR1   0x02
#define TIMER_CH_CNTRL_OCCM_SW_REF_CNT_CCR_OR_CNT_CCR1  0x03
#define TIMER_CH_CNTRL_OCCM_REF_1_DIR_0_CCR1_CNT_CCR    0x06
#define TIMER_CH_CNTRL_OCCM_REF_0_DIR_1_CCR_CNT_CCR1    0x06
#define TIMER_CH_CNTRL_OCCM_REF_0_DIR_0_CCR1_CNT_CCR    0x07
#define TIMER_CH_CNTRL_OCCM_REF_1_DIR_1_CCR_CNT_CCR1    0x07



#define TIMER1_IRQn         Timer1_IRQn
#define TIMER2_IRQn         Timer2_IRQn
#define TIMER3_IRQn         Timer3_IRQn

#endif

#define TIM1_IRQn           TIMER1_IRQn
#define TIM2_IRQn           TIMER2_IRQn
#define TIM3_IRQn           TIMER3_IRQn

#define TIM_Cmd(...)        TIMER_Cmd(__VA_ARGS__)

#define SysTick_MAX         (SysTick_LOAD_RELOAD_Msk)



//-----------------------------------------------------------------------------
// this is port of through all HALs
#define TIM_enable(TIMx)   TIM_Cmd((TIMx), ENABLE)
#define TIM_disable(TIMx)  TIM_Cmd((TIMx), DISABLE)
#define TIM_is_enabled(TIMx) (((TIMx->CNTRL & TIMER_CNTRL_CNT_EN) != 0)? 1: 0)

#define TIM_STATUS(TIMx)  (TIMx)->STATUS

#define TIM_IE(TIMx)  (TIMx)->IE
#define TIM_IE_enable(TIMx, mask)   SET_BIT(TIMx->IE, (mask) )
#define TIM_IE_disable(TIMx, mask)  CLEAR_BIT(TIMx->IE, (mask) )

#define TIM_IE_ZERO         1
#define TIM_IE_RELOAD       2

#define TIM_IE_OC1          0x200
#define TIM_IE_OC2          0x400
#define TIM_IE_OC3          0x800
#define TIM_IE_OC4          0x1000
#define TIM_IE_OCx          0x1E00
#define TIM_IE_OCx_Pos      9

#define TIM_SetAutoReload(io, x)    TIMER_SetCntAutoreload((io), (x) )

#define TIM_SetCHCompare(TIMx, ch, x) TIMER_SetChnCompare((TIMx), (ch), (x) )


#ifdef __cplusplus
extern "C" {
#endif

typedef MDR_TIMER_TypeDef   TIM_TypeDef;

/**
  * @brief  NVIC Init Structure definition
  */


#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
