/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#ifndef HAL_MDR32F9QX_MCU_USART_H_
#define HAL_MDR32F9QX_MCU_USART_H_

#include "MDR32F9Qx_uart.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef MDR_UART_TypeDef    USART_TypeDef;
typedef UART_InitTypeDef    USART_InitTypeDef;

#define USART_Init(...)     UART_Init(__VA_ARGS__)
#define USART_ITConfig(...) UART_ITConfig(__VA_ARGS__)
#define USART_GetFlagStatus(...) UART_GetFlagStatus(__VA_ARGS__)
#define USART_GetITStatus(...)   UART_GetITStatus(__VA_ARGS__)
#define USART_Cmd(...)      UART_Cmd(__VA_ARGS__)
#define USART_SendData(...) UART_SendData(__VA_ARGS__)
#define USART_ReceiveData(...)   UART_ReceiveData(__VA_ARGS__)

#define USART1              MDR_UART1
#define USART2              MDR_UART2
#define UART1               MDR_UART1
#define UART2               MDR_UART2
#define USART1_IRQn         UART1_IRQn
#define USART2_IRQn         UART2_IRQn

#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
