/*
 * switch_port.hpp
 *
 *  Created on: 13 нояб. 2018 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 *----------------------------------------------------------------------------
 * GPIOSwitch_Device - переключатель с выбором одного активного пина
 */

#ifndef HAL_STM32_SW_DEVICE_HPP_
#define HAL_STM32_SW_DEVICE_HPP_

#include <switch_hal.hpp>
#include <mcu_gpio.h>

/* GPIOSwitch_Device - переключатель с выбором одного активного пина
 * использование:
 *   // задать карту пинов переключателя
 *  const GPIOSwitch_Device::PIN_INIT sw_init[] = {
           BIMSW_PINDEF(A_PORT, A_PINID, A_STYLE)   //A
          ,BIMSW_PINDEF(B_PORT, B_PINID, B_STYLE)   //B
          ,BIMSW_PINDEF(C_PORT, C_PINID, C_STYLE)   //C
          ,BIMSW_PINDEF(NULL, 0, 0)
       };
    GPIOSwitch_Device iosw("ioswitch");
    ..........
        iosw.init(3, sw_init);
        iosw.select(0); // unselect any
        iosw.select(1); // selects A
        iosw.select(3); // selects C
        iosw.select(0); // unselect any
 * */

class GPIOSwitch_Device
    : public SwitchLine_Device
{
public:
    typedef SwitchLine_Device inherited;
    typedef PIN_INIT  PIN_INIT;

    GPIOSwitch_Device(dev_name name);

    /*
    virtual int init() {
        return inherited::init();
    };
    */

    using inherited::init;
    // настраивает батарею переключаемых пинов по массиву _pins
    // WARN: максимальное количество линий =32
    DevResult init(unsigned pinnum, const PIN_INIT* _pins);
    // тоже самое, но последний пин в массиве определяется по PIN_INIT:port == NULL
    DevResult init(const PIN_INIT* _pins);

    virtual DevResult deinit(){return DEV_NOT_IMPLEMENTED;};

protected:
    const PIN_INIT*   pins;
    // маска линий переключателя с инвертированным стилем
    unsigned    inverts;
    virtual int pin_set(unsigned id, unsigned state);
    virtual int pin_state(unsigned id) const;
};

//макро для объявления дескриптора линии, в массиве переключателей
#define GPIOSW_PINDEF(p, n, _style) PININIT_DEF(p, n, _style)



#endif /* HAL_MDR32F9QX_BIMSW_DEVICE_HPP_ */
