/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
*      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_MCU_SSP_H_
#define HAL_MCU_SSP_H_

#include <mcu-chip.h>
// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if defined(STM32F4)   //__STM32F4xx_HAL_CONF_H
#include <stm32f4xx_ll_spi.h>
#elif defined(STM32L1)   //__STM32F4xx_HAL_CONF_H
#include <stm32l1xx_ll_spi.h>
#else
#warning "uncknown STM32 HAL"
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef SPI_TypeDef SSP_TypeDef;

#define SPI_Enable(...)     LL_SPI_Enable(__VA_ARGS__)
#define SPI_Disable(...)    LL_SPI_Disable(__VA_ARGS__)

#define SPI_ReceiveData8(...)  LL_SPI_ReceiveData8(__VA_ARGS__)
#define SPI_ReceiveData16(...) LL_SPI_ReceiveData16(__VA_ARGS__)

#define SPI_TransmitData8(...)  LL_SPI_TransmitData8(__VA_ARGS__)
#define SPI_TransmitData16(...) LL_SPI_TransmitData16(__VA_ARGS__)

#define SPI_Is_TXE(...) LL_SPI_IsActiveFlag_TXE(__VA_ARGS__)
#define SPI_Is_RXNE(...) LL_SPI_IsActiveFlag_RXNE(__VA_ARGS__)
#define SPI_Is_BSY(...) LL_SPI_IsActiveFlag_BSY(__VA_ARGS__)

#define SPI_SetTransferBitOrder(...)    LL_SPI_SetTransferBitOrder(__VA_ARGS__)
#define SPI_LSB_FIRST LL_SPI_LSB_FIRST
#define SPI_MSB_FIRST LL_SPI_MSB_FIRST

#define SPI_SetDataWidth(...)           LL_SPI_SetDataWidth(__VA_ARGS__)
#define SPI_DATAWIDTH_8BIT       LL_SPI_DATAWIDTH_8BIT
#define SPI_DATAWIDTH_16BIT      LL_SPI_DATAWIDTH_16BIT

#define SPI_DATA_MODE0           (LL_SPI_PHASE_1EDGE |LL_SPI_POLARITY_LOW)
#define SPI_DATA_MODE1           (LL_SPI_PHASE_2EDGE |LL_SPI_POLARITY_LOW)
#define SPI_DATA_MODE2           (LL_SPI_PHASE_1EDGE |LL_SPI_POLARITY_HIGH)
#define SPI_DATA_MODE3           (LL_SPI_PHASE_2EDGE |LL_SPI_POLARITY_HIGH)

__STATIC_INLINE
void SPI_SetDataMode(SPI_TypeDef *SPIx, uint32_t mode){
    LL_SPI_SetClockPolarity(SPIx, mode);
    LL_SPI_SetClockPhase(SPIx, mode);
}

#define SPI_SetBaudRatePrescaler(...) LL_SPI_SetBaudRatePrescaler(__VA_ARGS__)
#define SPI_BAUDRATEPRESCALER_DIV2  LL_SPI_BAUDRATEPRESCALER_DIV2
#define SPI_BAUDRATEPRESCALER_DIV4  LL_SPI_BAUDRATEPRESCALER_DIV4
#define SPI_BAUDRATEPRESCALER_DIV8  LL_SPI_BAUDRATEPRESCALER_DIV8
#define SPI_BAUDRATEPRESCALER_DIV16 LL_SPI_BAUDRATEPRESCALER_DIV16
#define SPI_BAUDRATEPRESCALER_DIV32 LL_SPI_BAUDRATEPRESCALER_DIV32
#define SPI_BAUDRATEPRESCALER_DIV64 LL_SPI_BAUDRATEPRESCALER_DIV64
#define SPI_BAUDRATEPRESCALER_DIV128 LL_SPI_BAUDRATEPRESCALER_DIV128
#define SPI_BAUDRATEPRESCALER_DIV256 LL_SPI_BAUDRATEPRESCALER_DIV256



#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
