/*
 * mcu_flash.h
 *
 *  Created on: 4/05/2022
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
   Renesas RA2 chip flash memory API
 */

#ifndef BSP_CPU_MCU_FLASH_H_
#define BSP_CPU_MCU_FLASH_H_



enum MCUFlashTimes {

    // RA2L
    MCU_FLASH_CODE_SEC_SIZE         = 0x800,
    MCU_FLASH_CODE_PAGE_SIZE        = 4,

    // code sector (2KB) erase time
    MCU_FLASH_CODE_ERASE_48MHZ_TOMS = 215,
    MCU_FLASH_CODE_ERASE_8MHZ_TOMS  = 230,
    MCU_FLASH_CODE_ERASE_2MHZ_TOMS  = 280,
    MCU_FLASH_CODE_ERASE_1MHZ_TOMS  = 355,

    // code page (4byte) program time
    MCU_FLASH_CODE_PAGE_1MHZ_TOUS   = 740,
    MCU_FLASH_CODE_PAGE_2MHZ_TOUS   = 510,
    MCU_FLASH_CODE_PAGE_8MHZ_TOUS   = 360,
    MCU_FLASH_CODE_PAGE_48MHZ_TOUS  = 321,

};



#endif /* BSP_CPU_MCU_FLASH_H_ */
