/*
 * mcu_power.h
 *
 *  Created on: 9/9/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * --------------------------------------------------------------------------------------------------------------------
 *    LPM and power API.
 */

#ifndef BSP_CPU_MCU_PWR_H_
#define BSP_CPU_MCU_PWR_H_


#include <mcu-chip.h>


enum MCUPWRModeId {
    /// next WFI down to standby
    MCUPWR_MODE_STANDBY     = 1u, // R_SYSTEM_SBYCR_SSBY_Msk,

    /// next WFI down to sleep
    MCUPWR_MODE_SLEEP       = 0u,
};
typedef enum MCUPWRModeId   MCUPWRModeId;

///    Set Power Down mode when CPU enters deepsleep.
void    PWR_SetPowerMode (MCUPWRModeId PDMode);

__STATIC_INLINE
MCUPWRModeId    LL_PWR_GetPowerMode (void){
    return R_SYSTEM->SBYCR_b.SSBY;
}



//#define     LL_PWR_MODE_STOP_MAINREGU   0x00000000U
//#define     LL_PWR_MODE_STOP_LPREGU   (PWR_CR_LPDS)
//#define     LL_PWR_MODE_STOP_MAINREGU_UNDERDRIVE   (PWR_CR_MRUDS | PWR_CR_FPDS)
//#define     LL_PWR_MODE_STOP_LPREGU_UNDERDRIVE   (PWR_CR_LPDS | PWR_CR_LPUDS | PWR_CR_FPDS)
//#define     LL_PWR_MODE_STOP_MAINREGU_DEEPSLEEP   (PWR_CR_MRLVDS | PWR_CR_FPDS)
//#define     LL_PWR_MODE_STOP_LPREGU_DEEPSLEEP   (PWR_CR_LPDS | PWR_CR_LPLVDS | PWR_CR_FPDS)
#define     LL_PWR_MODE_STANDBY   MCUPWR_MODE_STANDBY

#define LL_PWR_SetPowerMode(PDMode)     PWR_SetPowerMode(PDMode)



/// Enables the Wake-up PINx functionality.
//void    HAL_PWR_EnableWakeUpPin (uint32_t WakeUpPinx)

/// Disables the Wake-up PINx functionality.
//void    HAL_PWR_DisableWakeUpPin (uint32_t WakeUpPinx)

/// Enters Stop mode.
//void    HAL_PWR_EnterSTOPMode (uint32_t Regulator, uint8_t STOPEntry)

/// Enters Sleep mode.
//void    HAL_PWR_EnterSLEEPMode (uint32_t Regulator, uint8_t SLEEPEntry)

/// Enters Standby mode.
//void    HAL_PWR_EnterSTANDBYMode (void)




#endif /* BSP_CPU_MCU_PWR_H_ */
