/*
 * mcu_gpio.h
 *
 *  Created on: 3/12/2020.
*      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is RL78 for STM SPL compatibily wrapers
 */

#ifndef HAL_RL78_MCU_GPIO_H_
#define HAL_RL78_MCU_GPIO_H_

#include <stdint.h>
#include <project-conf.h>
#include <mcu-chip.h>
//#include <r_iomap.h>

#include <c_compat.h>

#define GPIO_PORT_NO(port)  ( ((__near RP_IOR_CHAR* __near )&(port) - (__near RP_IOR_CHAR* __near )&P0) )
#define GPIO_PORTn(n)  ( ((__near RP_IOR_CHAR* __near )&P0)[(n)] )
#define GPIO_PINSn(n)  GPIO_PORTn( n )
#define GPIO_MODEn(n)  ( ((RP_IOR_CHAR*)&PM0)[(n)] )
#define GPIO_PULLn(n)  ( ((RP_IOR_CHAR*)&PU0)[(n)] )
#define GPIO_DRAINn(n)  ( ((RP_IOR_CHAR*)&POM0)[(n)] )

#ifdef __cplusplus
extern "C" {
#endif

typedef RP_SFR_CHAR             GPIO_TypeDef;
//typedef PORT_InitTypeDef        GPIO_InitTypeDef;
//#define GPIO_StructInit(...)    PORT_StructInit(__VA_ARGS__)
#define GPIO_Init(...)          RpMcuGpioMcuInit(__VA_ARGS__)

#ifdef __CCRL__

#define GPIO_SetBits( port, bits_mask )     { (port) |= (bit_mask); }
#define GPIO_ResetBits( port, bits_mask )   { (port) &= ~(bit_mask); }
//#define GPIO_WriteBit(...)                  LL_GPIO_WriteOutputPort(__VA_ARGS__)
#define GPIO_ReadInputData(port)            ((port))
#define GPIO_TwistBits(port, bits_mask)     {(port) ^= (bit_mask); }
#define GPIO_Bits(port, bits_mask )         ((port) & (bits_mask))

#if 1
#define GPIO_SETBIT( port, bit )            __set1( (unsigned char*)&(port), (bit) )
#define GPIO_CLRBIT( port, bit )            __clr1( (unsigned char*)&(port), (bit) )
#define GPIO_INVBIT( port, bit )            __not1( (unsigned char*)&(port), (bit) )
#else
#define GPIO_SETBIT( port, bit )            do { (port) |=  (1u<<(bit)); } while(0)
#define GPIO_CLRBIT( port, bit )            do { (port) &= ~(1u<<(bit)); } while(0)
#define GPIO_INVBIT( port, bit )            do { (port) ^= (1u<<(bit)); } while(0)
#endif

#define GPIO_WRBIT( port, bit, value )      { \
         if ((bit) == 0) ((RP_IOR_Bits*)&(port))->no0 = (value);\
    else if ((bit) == 1) ((RP_IOR_Bits*)&(port))->no1 = (value);\
    else if ((bit) == 2) ((RP_IOR_Bits*)&(port))->no2 = (value);\
    else if ((bit) == 3) ((RP_IOR_Bits*)&(port))->no3 = (value);\
    else if ((bit) == 4) ((RP_IOR_Bits*)&(port))->no4 = (value);\
    else if ((bit) == 5) ((RP_IOR_Bits*)&(port))->no5 = (value);\
    else if ((bit) == 6) ((RP_IOR_Bits*)&(port))->no6 = (value);\
    else if ((bit) == 7) ((RP_IOR_Bits*)&(port))->no7 = (value);\
    }

#define GPIO_GETBIT( port, bit )      ( \
     ((bit) == 0)? ((RP_IOR_Bits*)&(port))->no0 \
    :((bit) == 1)? ((RP_IOR_Bits*)&(port))->no1 \
    :((bit) == 2)? ((RP_IOR_Bits*)&(port))->no2 \
    :((bit) == 3)? ((RP_IOR_Bits*)&(port))->no3 \
    :((bit) == 4)? ((RP_IOR_Bits*)&(port))->no4 \
    :((bit) == 5)? ((RP_IOR_Bits*)&(port))->no5 \
    :((bit) == 6)? ((RP_IOR_Bits*)&(port))->no6 \
    :((bit) == 7)? ((RP_IOR_Bits*)&(port))->no7 \
    : 0 )

#endif


//* pin operations are for pinName:MCU_PINS enumerated pins
#define GPIO_SETPIN( pin )  GPIO_SETBIT( GPIO_PORTn(((pin)>>4)&0xf) , (pin)&0xf )
#define GPIO_CLRPIN( pin )  GPIO_CLRBIT( GPIO_PORTn(((pin)>>4)&0xf) , (pin)&0xf )
#define GPIO_INVPIN( pin )  GPIO_INVBIT( GPIO_PORTn(((pin)>>4)&0xf) , (pin)&0xf )
#define GPIO_WRPIN( pin, x )  GPIO_WRBIT( GPIO_PORTn(((pin)>>4)&0xf) , (pin)&0xf , (x) )
#define GPIO_GETPIN( pin )  GPIO_GETBIT( GPIO_PORTn(((pin)>>4)&0xf) , (pin)&0xf )



#if 0
// описатель стиля пина, для упрощенного объявления структуры инициализации пина PIN_INIT
enum PinStyle{
    psINV     = 1, //inverted
    psOD      = 2, //open drain
    psANALOG  = 0x10, //pull up
    psPU      = 0x20, //pull up
    psPullUp  = psPU,
    psPD      = 0x40, //pull dn
    psPullDn  = psPD,
    psNONE    = 0,
};

struct PIN_INIT_s{
    GPIO_TypeDef*   port;
    uint8_t         pin;
    uint8_t         style; // \sa PinStyle
};
typedef struct PIN_INIT_s PIN_INIT;
#define PININIT_DEF(p, n, _style) {\
        struct_field(port) p, struct_field(pin) n, struct_field(style) _style\
    }
#endif


#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
