/*
    (C) 2017 Renesas Electronics Corporation.
     This software is released under the terms and conditions described in LICENSE_RENESAS.TXT included in the project.
*/
/**
  * @file    rl78g14_uart.h
  * @author  Renesas Electronics Corporation
  * @brief   Sample UART driver program header.
**/

#if !defined (__R_RL78G14_UART_H__)
#define __R_RL78G14_UART_H__



/***********************************************************
 * define
 **********************************************************/
/* baudrate sertting */
#if (RP_CPU_CLK==32) //fih = 32 MHz
#define BPS2400				11
#define	BPS4800				10
#define	BPS9600				9
#define	BPS19200			8
#define	BPS38400			7
#define	BPS115200			1
#define	BPS230400			0

#else
#define BPS2400				10
#define	BPS4800				9
#define	BPS9600				8
#define	BPS19200			7
#define	BPS38400			6
#define	BPS115200			0
#endif

/***********************************************************
 * prototype
 **********************************************************/
void RpMcuUartInit(void);
int16_t RpMcuUartGetChar(void);			// declaration was incompatible with the function in .c
int RpMcuUartPutChar(unsigned char ch);
bool RpMcuUartCheckTxDone(void);
void RpMcuUartDeInit(void);






/***********************************************************************
 *	Serial
 **********************************************************************/
/***********************************************************
 *	Serial Clock Select Register m (SPSm)
 **********************************************************/
/* Operating mode and clear mode selection(PRS013~PRS010) */
#define SAU_CK01_FCLK_0				0x0000		/* ck01-fclk */
#define SAU_CK01_FCLK_1				0x0010		/* ck01-fclk/2^1 */

/***********************************************************
 * Serial Mode Register mn (SMRmn)
 **********************************************************/
/* Initial Value */
#define	SAU_SMRMN_INITIALVALUE		0x0020

/* Selection of macro clock (MCK) of channel n(CKSmn) */
#define SAU_CLOCK_SELECT_CLR		0x8000		/* for clear the bits */
#define SAU_CLOCK_SELECT_CK00		0x0000		/* operation clock CK0 set by PRS register */
#define SAU_CLOCK_SELECT_CK01		0x8000		/* 0peration clock CK1 set by PRS register */

/* Selection of transfer clock (TCLK) of channel n(CCSmn) */
#define SAU_CLOCK_MODE_CLR			0x4000		/* for clear the bits */
#define SAU_CLOCK_MODE_CKS			0x0000		/* divided operation clock MCK specified by CKSmn bit */
#define SAU_CLOCK_MODE_TI0N			0x4000		/* clock input from SCK pin (slave transfer in CSI mode) */

/* Selection of start trigger source(STSmn) */
#define SAU_TRIGGER_CLR				0x0100		/* for clear the bits */
#define SAU_TRIGGER_SOFTWARE		0x0000		/* only software trigger is valid */
#define SAU_TRIGGER_RXD				0x0100		/* valid edge of RXD pin */

/* Setting of operation mode of channel n(MDmn2,MDmn1) */
#define SAU_MODE_CSI				0x0000		/* CSI mode */
#define SAU_MODE_UART				0x0002		/* UART mode */
#define SAU_MODE_IIC				0x0004		/* simplified IIC mode */

/* Selection of interrupt source of channel n(MDmn0) */
#define SAU_TRANSFER_END			0x0000		/* transfer end interrupt */
#define SAU_BUFFER_EMPTY			0x0001		/* buffer empty interrupt */

/* Controls inversion of level of receive data of channel n in UART mode (SISmn0) */
#define SAU_EDGE_FALL              (0x0000U)    /* falling edge is detected as the start bit */
#define SAU_EDGE_RISING            (0x0040U)    /* rising edge is detected as the start bit */

/***********************************************************
 * Serial Communication Operation Setting Register mn (SCRmn)
 **********************************************************/
/* Setting of operation mode of channel n(TXEmn,RXEmn) */
#define SAU_NOT_COMMUNICATION		0x0000		/* does not start communication */
#define SAU_RECEPTION				0x4000		/* reception only */
#define SAU_TRANSMISSION			0x8000		/* transmission only */
#define SAU_RECEPTION_TRANSMISSION	0xc000		/* reception and transmission */

/* Selection of data and clock phase in CSI mode(DAPmn,CKPmn) */
#define SAU_TIMING_1				0x0000		/* type 1 */
#define SAU_TIMING_2				0x1000		/* type 2 */
#define SAU_TIMING_3				0x2000		/* type 3 */
#define SAU_TIMING_4				0x3000		/* type 4 */

/* Selection of masking of error interrupt signal(EOCmn) */
#define SAU_INTSRE_MASK				0x0000		/* masks error interrupt INTSREx */
#define SAU_INTSRE_ENABLE			0x0400		/* enables generation of error interrupt INTSREx */

/* Setting of parity bit in UART mode(PTCmn1,PTCmn0) */
#define SAU_PARITY_NONE				0x0000		/* none parity */
#define SAU_PARITY_ZERO				0x0100		/* zero parity */
#define SAU_PARITY_EVEN				0x0200		/* even parity */
#define SAU_PARITY_ODD				0x0300		/* odd parity */

/* Selection of data transfer sequence in CSI and UART modes(DIRmn) */
#define SAU_MSB						0x0000		/* MSB */
#define SAU_LSB						0x0080		/* LSB */

/* Setting of stop bit in UART mode(SLCmn1,SLCmn0) */
#define SAU_STOP_NONE				0x0000		/* none stop bit */
#define SAU_STOP_1					0x0010		/* 1 stop bit */
#define SAU_STOP_2					0x0020		/* 2 stop bits */

/* Setting of data length in CSI and UART modes(DLSmn2~DLSmn0) */
#define SAU_LENGTH_5				0x0004		/* 5-bit data length */
#define SAU_LENGTH_7				0x0006		/* 7-bit data length */
#define SAU_LENGTH_8				0x0007		/* 8-bit data length */

/***********************************************************
 * Serial Output Level Register m (SOLm)
 **********************************************************/
/* Selects inversion of the level of the transmit data of channel n in UART mode */
#define SAU_CHANNEL0_NORMAL			0x0000		/* normal bit level */
#define SAU_CHANNEL0_INVERTED		0x0001		/* inverted bit level */

#define SAU_CHANNEL2_NORMAL			0x0000		/* normal bit level */
#define SAU_CHANNEL2_INVERTED		0x0004		/* inverted bit level */

#define SAU_CHANNEL3_NORMAL			0x0000		/* normal bit level */
#define SAU_CHANNEL3_INVERTED		0x0008		/* inverted bit level */

/***********************************************************
 * Format of Serial Status Register mn (SSRmn)
 **********************************************************/
/* Communication status indication flag of channel n(TSFmn) */
#define SAU_UNDER_EXECUTE			0x0040		/* communication is under execution */
#define SAU_DATA_STORED				0x0020		/* valid data is stored SDRmn register */

/* Parity error detection flag of channel n(PEFmn) */
#define	SAU_FRAMING_ERROR			0x0004		/* a framing error occurs during UART reception */
#define SAU_PARITY_ERROR			0x0002		/* a parity error occurs during UART reception or ACK is not detected during I2C transmission */
#define	SAU_OVERRUN_ERROR			0x0001		/* a overrun error during UART reception */

/***********************************************************
 * Serial Channel Start Register m (SSm)
 **********************************************************/
/* Operation start trigger of channel 0(SSm0) */
#define SAU_CH0_START_TRG_OFF		0x0000		/* no trigger operation */
#define SAU_CH0_START_TRG_ON		0x0001		/* sets SEm0 to 1 and enters the communication wait status */

/* Operation start trigger of channel 1(SSm1) */
#define SAU_CH1_START_TRG_OFF		0x0000	/* no trigger operation */
#define SAU_CH1_START_TRG_ON		0x0002	/* sets SEm1 to 1 and enters the communication wait status */

/* Operation start trigger of channel 2(SSm2) */
#define SAU_CH2_START_TRG_OFF		0x0000		/* no trigger operation */
#define SAU_CH2_START_TRG_ON		0x0004		/* sets SEm2 to 1 and enters the communication wait status */

/* Operation start trigger of channel 3(SSm3) */
#define SAU_CH3_START_TRG_OFF		0x0000		/* no trigger operation */
#define SAU_CH3_START_TRG_ON		0x0008		/* sets SEm3 to 1 and enters the communication wait status */

/***********************************************************
 * Serial Channel Stop Register m (STm)
 **********************************************************/
/* Operation stop trigger of channel 0(STm0) */
#define SAU_CH0_STOP_TRG_OFF		0x0000		/* no trigger operation */
#define SAU_CH0_STOP_TRG_ON			0x0001		/* operation is stopped (stop trigger is generated) */

/* Operation stop trigger of channel 1(STm1) */
#define SAU_CH1_STOP_TRG_OFF		0x0000	/* no trigger operation */
#define SAU_CH1_STOP_TRG_ON			0x0002	/* operation is stopped (stop trigger is generated) */

/* Operation stop trigger of channel 2(STm2) */
#define SAU_CH2_STOP_TRG_OFF		0x0000		/* no trigger operation */
#define SAU_CH2_STOP_TRG_ON			0x0004		/* operation is stopped (stop trigger is generated) */

/* Operation stop trigger of channel 3(STm3) */
#define SAU_CH3_STOP_TRG_OFF		0x0000		/* no trigger operation */
#define SAU_CH3_STOP_TRG_ON			0x0008		/* operation is stopped (stop trigger is generated) */

/***********************************************************
 * Format of Serial Flag Clear Trigger Register mn (SIRmn)
 **********************************************************/
/* Clear trigger of overrun error flag of channel n(OVCTmn) */
#define	SAU_SIRMN_OVCTMN			0x0001

/* Clear trigger of parity error flag of channel n(PECTmn) */
#define	SAU_SIRMN_PECTMN			0x0002

/* Clear trigger of framing error of channel n(FECTMN) */
#define	SAU_SIRMN_FECTMN			0x0004

/***********************************************************
 * Serial Output Enable Register m (SOEm)
 **********************************************************/
/* Serial output enable/disable of channel 0(SOEm0) */
#define SAU_CH0_OUTPUT_ENABLE		0x0001		/* stops output by serial communication operation */
#define SAU_CH0_OUTPUT_DISABLE		0x0000		/* enables output by serial communication operation */

/* Serial output enable/disable of channel 2(SOEm2) */
#define SAU_CH2_OUTPUT_ENABLE		0x0004		/* stops output by serial communication operation */
#define SAU_CH2_OUTPUT_DISABLE		0x0000		/* enables output by serial communication operation */

/* Serial output enable/disable of channel 3(SOEm3) */
#define SAU_CH3_OUTPUT_ENABLE		0x0008		/* stops output by serial communication operation */
#define SAU_CH3_OUTPUT_DISABLE		0x0000		/* enables output by serial communication operation */

/***********************************************************
 * Serial Output Register m (SOm)
 **********************************************************/
/* Serial data output of channel 0(SOm0) */
#define SAU_CH0_DATA_OUTPUT_0		0x0000		/* Serial data output value is 0*/
#define SAU_CH0_DATA_OUTPUT_1		0x0001		/* Serial data output value is 1*/

/* Serial data output of channel 2(SOm2) */
#define SAU_CH2_DATA_OUTPUT_0		0x0000		/* Serial data output value is 0*/
#define SAU_CH2_DATA_OUTPUT_1		0x0004		/* Serial data output value is 1*/

/* Serial data output of channel 3(SOm3) */
#define SAU_CH3_DATA_OUTPUT_0		0x0000		/* Serial data output value is 0*/
#define SAU_CH3_DATA_OUTPUT_1		0x0008		/* Serial data output value is 1*/

/* Serial clock output of channel 0(CKOm0) */
#define SAU_CH0_CLOCK_OUTPUT_0		0x0000		/* Serial clock output value is 0*/
#define SAU_CH0_CLOCK_OUTPUT_1		0x0100		/* Serial clock output value is 1*/

/* Serial clock output of channel 2(CKOm2) */
#define SAU_CH2_CLOCK_OUTPUT_0		0x0000		/* Serial clock output value is 0*/
#define SAU_CH2_CLOCK_OUTPUT_1		0x0400		/* Serial clock output value is 1*/

/* Serial clock output of channel 3(CKOm3) */
#define SAU_CH3_CLOCK_OUTPUT_0		0x0000		/* Serial clock output value is 0*/
#define SAU_CH3_CLOCK_OUTPUT_1		0x0800		/* Serial clock output value is 1*/


/***********************************************************
 * Noise Filter Enable Register 0 (NFEN0)
 **********************************************************/
/* Use of noise filter */
#define SAU_RXD3_FILTER_OFF          (0x00U)      /* noise filter off */
#define SAU_RXD3_FILTER_ON           (0x40U)      /* noise filter on */
#define SAU_RXD2_FILTER_OFF          (0x00U)      /* noise filter off */
#define SAU_RXD2_FILTER_ON           (0x10U)      /* noise filter on */
#define SAU_RXD1_FILTER_OFF          (0x00U)      /* noise filter off */
#define SAU_RXD1_FILTER_ON           (0x04U)      /* noise filter on */
#define SAU_RXD0_FILTER_OFF          (0x00U)      /* noise filter off */
#define SAU_RXD0_FILTER_ON           (0x01U)      /* noise filter on */



#define		putc				RpMcuUartPutChar


#ifdef __CCRL__
void			RpMcuPrint(char __far *str);
#elif __ICCRL78__
void			RpMcuPrint(char __far *str);
#else
void			RpMcuPrint(char *str);
#endif
void			RpMcuPrintHex(unsigned long l, unsigned char len);
void			RpMcuPrintDec(long d, unsigned char len, unsigned char pre);



#endif // #if !defined (__R_RL78G14_UART_H__)
