/*
 * x25_flash.h
 *
 *  Created on: 15 янв. 2019 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * -----------------------------------------------------------------------
 * здесь положу некоторые объявления параметров флешек, доступные для С-кода
 */

#ifndef HAL_FLASH_X25_FLASH_H_
#define HAL_FLASH_X25_FLASH_H_



#define W25Q64_PAGE_SIZE 256
#define W25Q64_SEC_SIZE  (4<<10)
#define W25Q64_SEC_PAGES (W25Q64_SEC_SIZE/W25Q64_PAGE_SIZE)
#define W25Q64_SECTORS   (128*16)
#define W25Q64_PAGES     (W25Q64_SECTORS*W25Q64_SEC_PAGES)
#define W25Q64_SIZE      (W25Q64_SECTORS*W25Q64_SEC_SIZE)

#ifdef __cplusplus
#include <flash/x25_flash.hpp>
#endif



#endif /* HAL_FLASH_X25_FLASH_H_ */
