#ifndef TELNETD_CLI_HPP
#define TELNETD_CLI_HPP

#include <QObject>
#include <lib/cli/qshell_telnet.hpp>
#include "core_cli.hpp"



class CLITelnetService : public QObject 
                        , public CLICore 
{
    Q_OBJECT
public:
    typedef CLICore inherited;
    CLITelnetService(const_cmd _cmd, core_t& x);

public:
    int cli_start(CLI_shell* shell, const_line line);

public:
	// TODO сервис демонов телнет надо куда то опубликовать, пошарить
	//startup telnet daemon on port
	void start_telnetd(quint16 port);

	void destroy_demons();
	void shutdown_demons();

signals:
	void destroy_all();
	void shutdown_all();

public:
    virtual bool event(::QEvent *event); 

	class TelnetdEvent : public cli::QEvent {
	public:
		typedef TelnetdEvent type_t;
		int		port;

		TelnetdEvent():QEvent(), port(0){}
		TelnetdEvent(TelnetdEvent &other)
		    :QEvent(other), port(other.port)
		{}

		virtual QEvent&& copy(void){
			return std::move(*(new type_t(*this)));
		}

		type_t&& dup(void){
			return std::move(*(new type_t(*this)));
		}

		type_t&& assign_port(int	x) && {
			port = x;
			return std::move(*this);
		}
	};

	static TelnetdEvent		evStartTelnetDaemon;

};



#include "telnetd.hpp"
#include <cstring>

class CLITelnetDaemon : //public QObject ,
                        public QCLIDeviceCommands 
{
public:
    typedef QCLIDeviceCommands inherited;
    typedef TelnetDaemon       daemon_t;
    CLITelnetDaemon(const std::string& _cmd, daemon_t& adaemon);
    virtual ~CLITelnetDaemon();

    int cli_close(CLI_shell* shell, const_line line);
    int cli_shutdown(CLI_shell* shell, const_line line);

protected:
    daemon_t&   _daemon;
    std::string name;

};



#endif // TELNETD_CLI_HPP
