/*
 * bcd.h
 *
 *  Created on: 12/04/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * --------------------------------------------------------------------------------
 * BCD number
 */

#ifndef LIB_NUMERIC_BCD_H_
#define LIB_NUMERIC_BCD_H_

#include <stdint.h>

/*!
 * \brief Converts BCD number to decimal
 * \param[IN] bcd 1-byte BCD number to convert.
 * \return Decimal number
 */
static inline
uint8_t bcd2num(uint8_t bcd)
{
    return (uint8_t)((bcd & 0x0f) + ((bcd >> 4) * 10u));
}


/*!
 * \brief Converts decimal number to BCD
 * \param[IN] dec Decimal number to convert. Valid range: 00 to 99.
 * \return BCD number
 */
static inline
uint8_t num2bcd(uint8_t dec)
{
    extern const uint8_t bcd_table[100];
    return bcd_table[dec];
}





#endif /* LIB_NUMERIC_BCD_H_ */
