/*
 * stats_util.h
 *
 *  Created on: 22/07/2022
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
      statistics structures
 */

#ifndef LIB_STATS_UTIL_H_
#define LIB_STATS_UTIL_H_

#include "memoryx.h"
#include <stdint.h>


/** @brief limited collector of values with attached items.
 *      New items replaces minimum value in collection, in it lower
 * */
typedef struct HCollectorMaxU {
    uint_fast16_t   count;      //< count of values/items[]

    uint_fast16_t   min_idx;    //< lowest value to replace index
    unsigned        min_value;  //< lowest value to replace

    void**          items;      //< items attached to values
    unsigned        values[];   //< values collection
} HCollectorMaxU;

void collector_max_init( HCollectorMaxU* x, unsigned count, void** items);
void collector_max_append( HCollectorMaxU* x, unsigned value, void* item);



#endif /* LIB_STATS_UTIL_H_ */
