/*
 * str_util.c
 *
 *  Created on: 22//11/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne
 */

#include <stdint.h>
#include "str_util.h"
#include "string.h"
#include "memory.h"



char* str_insertc(char* s, char x){
    unsigned len = strlen(s);
    memmove(s+1, s, len+1);
    s[0] = x;
    return s;
}

char* str_rinsertc(char* s, unsigned fromtail, char x){
    unsigned len = strlen(s);
    if (len < fromtail)
        return s;

    char* y = s+len-fromtail;
    len = fromtail;
    memmove(y+1, y, len+1);
    y[0] = x;

    return s;
}



/// @brief dump hex bytes low cap
/// @return length of dump str
int  sldump_hex(char* buf, unsigned bufsz, const void* data, unsigned sz){
    const uint8_t* pd = (const uint8_t*)data;
    char* s = buf;
    const char *hex = "0123456789abcdef";

    for (; (bufsz > 1) && (sz > 0) ; --sz, bufsz -=2, s += 2){
        uint8_t v = *pd++;
        s[0] = hex[(v / 16)];
        s[1] = hex[(v % 16)];
    }

    if (bufsz > 0)
        *s++ = '\0';
    return s - buf;
}

int  sldump_HEX(char* buf, unsigned bufsz, const void* data, unsigned sz){
    const uint8_t* pd = (const uint8_t*)data;
    char* s = buf;
    const char *hex = "0123456789ABCDEF";

    for (; (bufsz > 1) && (sz > 0) ; --sz, bufsz -=2, s += 2){
        uint8_t v = *pd++;
        s[0] = hex[(v / 16)];
        s[1] = hex[(v % 16)];
    }

    if (bufsz > 0)
        *s++ = '\0';
    return s - buf;
}
