/*
 * OsSync.h
 * ru - CP1251
 *
 *  Created on: 3 . 2017 .
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 *  ------------------------------------------------------------------------
 *     -    contiki.
 */

#ifndef OSSYNC_H_
#define OSSYNC_H_

#include <stdint.h>
#include <stdbool.h>

#include "compiler-port.h"
#include <hal_types.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <contiki-conf.h>
#include <sys/process.h>
#include <lib/list.h>
#include <sys/etimer.h>
#include <sys/pt-sem.h>
#include <ptx.h>

#ifdef __cplusplus
}
#endif

#include <os_isr.h>


typedef int   OSError;


//     .     
//   
typedef clock_time_t    TickType_t;

//  [ms] -> [tick]
#define OSTicksMS(ms)   ( (ms* CLOCK_SECOND) /1000)

//         
#define TO_INFINITE     (~0ul)
//#include <sys/clock.h>



//***************************************************************************
//                      Critical Section

//       
//    .
// TODO:    ?
extern  struct OS_CriticalSec_t {
    int         level;
    isr_save_t  saveie;
} OS_CriticalSec;

//   ,        
//   ,    __disable_irq/__enable_irq
INLINE
void ENTER_CS() {
    __disable_irq();
    isr_save_t  saveie = gie_disable();
    if (OS_CriticalSec.level == 0){
        OS_CriticalSec.saveie = saveie;
    }
    OS_CriticalSec.level++;
    __enable_irq();
}

INLINE
void EXIT_CS() {
    __disable_irq();
    OS_CriticalSec.level--;
    if (OS_CriticalSec.level<= 0){
        OS_CriticalSec.level = 0;
        gie_restore(OS_CriticalSec.saveie);
    }
    __enable_irq();
}

#ifndef SYNC_CS_INLINE
#define SYNC_CS_INLINE 0
#endif

#if SYNC_CS_INLINE
#define EnterCS() ENTER_CS()
#define ExitCS()  EXIT_CS()
#else
void EnterCS(void);
void ExitCS(void);
#endif

#define EnterCS_ISR(x)  (EnterCS(), OS_CriticalSec.saveie)
#define ExitCS_ISR(x)   ExitCS()



#ifdef __cplusplus
// this guards atomic code block execution
class CSGuard {
    public:
        CSGuard(){EnterCS();};
        ~CSGuard(){ExitCS();};
};
#endif



#ifndef SYNC_STRICT
#define SYNC_STRICT 0
#endif
#if SYNC_STRICT
#include <cassert>
#define sync_assert(x)  assert(x)
#else
#define sync_assert(x)
#endif


//***************************************************************************
//                      Tasks

//    .
typedef struct process  task_t;
//   . (   (freeRTOS) -     )
typedef struct process* task_h;

INLINE
task_h  task_current(void){
  return process_current;
}

INLINE
void task_delete(){
    //process_exit(task_current());
    process_abort();
}

INLINE
const char* task_name(task_h t){
    return PROCESS_NAME_STRING(t);
}



#ifdef __cplusplus

//***************************************************************************
//  ""      
//       

#include <pt-SyncActive.hpp>

typedef ActiveMutex     Mutex;
typedef ActiveMutex_t   mutex_t;
typedef mutex_t*        mutex_h;

typedef ActiveSignal    Signal;


#endif /* __cplusplus */


#endif /* OSSYNC_H_ */
