#ifndef STDIO_HAL_HPP_
#define STDIO_HAL_HPP_

/*
 * stdio_hal.hpp
 *
 *  Created on: 9/12/2019
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 * this is a stdio part of hal_devices. used by pront_hal, to avoid full hal_device
 * dependences
 */



class HAL_OUTBlock_Device{
public:
  //* блокирующая печать
  virtual int puts( const char* str) = 0;
  //*  \return - длинна отправленного участка
  virtual int putData ( const void* str, unsigned len) = 0;

  //*  ожидание доступности печати
  //*  \return - количество байт возможных для неблокирующей печати
  virtual int put_wait(unsigned to = 0) = 0;
  //*  почти тоже put_wait, ждет полного опустошения
  virtual int put_flush(unsigned to = 0) = 0;
  //*  очищает буфер, прерывая текущую отправку
  virtual int put_drop() = 0;

  //* монополизация вывода (puts, putData предпочтительно использую ее )
  //* \arg onoff - захват/освобождение
  //* \return    - состояние захвачн ли вывод
  static const unsigned toInfinite = ~0;
  virtual bool put_access(bool onoff, unsigned to = toInfinite) = 0;
};

class StdOUT_Device
    : public HAL_OUTBlock_Device
{
public:
    //* блокирующая печать
    virtual int putChar(int ch) = 0;

    //*  неблокирующая печать
    virtual int postData ( const void* str, unsigned len) = 0;

};

class HAL_INBlock_Device{
public:
    // блокирующий прием
    //*  \return - длинна полученного участка
    virtual int getData ( void* dst, unsigned len) = 0;
    //*  ожидание amount доступных символов
    virtual int get_waitfor(unsigned amount, unsigned to = 0) = 0;
};

class StdIO_Device
  : public StdOUT_Device
{
public:
    virtual int get_char() = 0;
    // @return - amount of availiable data.
    virtual int get_wait(unsigned to = 0) = 0;
//    virtual int printf ( const char* str) = 0;

private:
};



#endif /* STDIO_HAL_HPP_ */
